/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.exhaustivesearch.ExhaustiveSearchPhase;
import org.optaplanner.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultExhaustiveSearchPhase
extends AbstractPhase
implements ExhaustiveSearchPhase {
    protected Comparator<ExhaustiveSearchNode> nodeComparator;
    protected EntitySelector entitySelector;
    protected ExhaustiveSearchDecider decider;
    protected boolean assertWorkingSolutionScoreFromScratch = false;
    protected boolean assertExpectedWorkingSolutionScore = false;

    public Comparator<ExhaustiveSearchNode> getNodeComparator() {
        return this.nodeComparator;
    }

    public void setNodeComparator(Comparator<ExhaustiveSearchNode> nodeComparator) {
        this.nodeComparator = nodeComparator;
    }

    public EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public void setEntitySelector(EntitySelector entitySelector) {
        this.entitySelector = entitySelector;
    }

    public ExhaustiveSearchDecider getDecider() {
        return this.decider;
    }

    public void setDecider(ExhaustiveSearchDecider decider) {
        this.decider = decider;
    }

    public void setAssertWorkingSolutionScoreFromScratch(boolean assertWorkingSolutionScoreFromScratch) {
        this.assertWorkingSolutionScoreFromScratch = assertWorkingSolutionScoreFromScratch;
    }

    public void setAssertExpectedWorkingSolutionScore(boolean assertExpectedWorkingSolutionScore) {
        this.assertExpectedWorkingSolutionScore = assertExpectedWorkingSolutionScore;
    }

    @Override
    public String getPhaseTypeString() {
        return "Exhaustive Search";
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        TreeSet<ExhaustiveSearchNode> expandableNodeQueue = new TreeSet<ExhaustiveSearchNode>(this.nodeComparator);
        ExhaustiveSearchPhaseScope phaseScope = new ExhaustiveSearchPhaseScope(solverScope);
        phaseScope.setExpandableNodeQueue(expandableNodeQueue);
        this.phaseStarted(phaseScope);
        while (!expandableNodeQueue.isEmpty() && !this.termination.isPhaseTerminated(phaseScope)) {
            ExhaustiveSearchStepScope stepScope = new ExhaustiveSearchStepScope(phaseScope);
            ExhaustiveSearchNode node = (ExhaustiveSearchNode)expandableNodeQueue.last();
            expandableNodeQueue.remove(node);
            stepScope.setExpandingNode(node);
            this.stepStarted(stepScope);
            this.restoreWorkingSolution(stepScope);
            this.decider.expandNode(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.entitySelector.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    public void phaseStarted(ExhaustiveSearchPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.entitySelector.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        this.fillLayerList(phaseScope);
        this.initStartNode(phaseScope);
    }

    private void fillLayerList(ExhaustiveSearchPhaseScope phaseScope) {
        ExhaustiveSearchStepScope stepScope = new ExhaustiveSearchStepScope(phaseScope);
        this.entitySelector.stepStarted(stepScope);
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The entitySelector (" + this.entitySelector + ") has an entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        ArrayList<ExhaustiveSearchLayer> layerList = new ArrayList<ExhaustiveSearchLayer>((int)entitySize);
        int depth = 0;
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        int uninitializedVariableCount = phaseScope.getSolutionDescriptor().countReinitializableVariables(scoreDirector, phaseScope.getWorkingSolution());
        for (Object entity : this.entitySelector) {
            ExhaustiveSearchLayer layer = new ExhaustiveSearchLayer(depth, entity, uninitializedVariableCount);
            int reinitializeVariableCount = this.entitySelector.getEntityDescriptor().countReinitializableVariables(scoreDirector, entity);
            if (reinitializeVariableCount == 0) continue;
            ++depth;
            uninitializedVariableCount -= reinitializeVariableCount;
            layerList.add(layer);
        }
        ExhaustiveSearchLayer lastLayer = new ExhaustiveSearchLayer(depth, null, uninitializedVariableCount);
        layerList.add(lastLayer);
        this.entitySelector.stepEnded(stepScope);
        phaseScope.setLayerList(layerList);
    }

    private void initStartNode(ExhaustiveSearchPhaseScope phaseScope) {
        ExhaustiveSearchLayer startLayer = phaseScope.getLayerList().get(0);
        ExhaustiveSearchNode startNode = new ExhaustiveSearchNode(startLayer, null);
        if (this.decider.isScoreBounderEnabled()) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            Score score = scoreDirector.calculateScore();
            startNode.setScore(score);
            ScoreBounder scoreBounder = this.decider.getScoreBounder();
            phaseScope.setBestPessimisticBound(startLayer.isLastLayer() ? score : scoreBounder.calculatePessimisticBound(scoreDirector, score));
            startNode.setOptimisticBound(startLayer.isLastLayer() ? score : scoreBounder.calculateOptimisticBound(scoreDirector, score));
        }
        if (!startLayer.isLastLayer()) {
            phaseScope.addExpandableNode(startNode);
        }
        phaseScope.getLastCompletedStepScope().setExpandingNode(startNode);
    }

    public void stepStarted(ExhaustiveSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    protected void restoreWorkingSolution(ExhaustiveSearchStepScope stepScope) {
        ExhaustiveSearchPhaseScope phaseScope = stepScope.getPhaseScope();
        ExhaustiveSearchNode oldNode = phaseScope.getLastCompletedStepScope().getExpandingNode();
        ExhaustiveSearchNode newNode = stepScope.getExpandingNode();
        ArrayList<Move> oldMoveList = new ArrayList<Move>(oldNode.getDepth());
        ArrayList<Move> newMoveList = new ArrayList<Move>(newNode.getDepth());
        while (oldNode != newNode) {
            int newDepth;
            int oldDepth = oldNode.getDepth();
            if (oldDepth < (newDepth = newNode.getDepth())) {
                newMoveList.add(newNode.getMove());
                newNode = newNode.getParent();
                continue;
            }
            oldMoveList.add(oldNode.getUndoMove());
            oldNode = oldNode.getParent();
        }
        ArrayList<Move> restoreMoveList = new ArrayList<Move>(oldMoveList.size() + newMoveList.size());
        restoreMoveList.addAll(oldMoveList);
        Collections.reverse(newMoveList);
        restoreMoveList.addAll(newMoveList);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        for (Move restoreMove : restoreMoveList) {
            restoreMove.doMove(scoreDirector);
        }
        phaseScope.getWorkingSolution().setScore(stepScope.getStartingStepScore());
        if (this.assertWorkingSolutionScoreFromScratch && stepScope.getStartingStepScore() != null) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getStartingStepScore(), restoreMoveList);
        }
        if (this.assertExpectedWorkingSolutionScore && stepScope.getStartingStepScore() != null) {
            phaseScope.assertExpectedWorkingScore(stepScope.getStartingStepScore(), restoreMoveList);
        }
    }

    public void stepEnded(ExhaustiveSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            ExhaustiveSearchPhaseScope phaseScope = stepScope.getPhaseScope();
            long timeMillisSpent = phaseScope.calculateSolverTimeMillisSpent();
            this.logger.debug("    ES step ({}), time spent ({}), treeId ({}), {} best score ({}), selected move count ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpent, stepScope.getTreeId(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScoreWithUninitializedPrefix(), stepScope.getSelectedMoveCount()});
        }
    }

    public void phaseEnded(ExhaustiveSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.entitySelector.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        this.logger.info("Exhaustive Search phase ({}) ended: step total ({}), time spent ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getNextStepIndex(), phaseScope.calculateSolverTimeMillisSpent(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.entitySelector.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

