/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class TailChainSwapMove
extends AbstractMove {
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    protected final AnchorVariableSupply anchorVariableSupply;
    protected final Object leftEntity;
    protected final Object rightValue;

    public TailChainSwapMove(GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, AnchorVariableSupply anchorVariableSupply, Object leftEntity, Object rightValue) {
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.anchorVariableSupply = anchorVariableSupply;
        this.leftEntity = leftEntity;
        this.rightValue = rightValue;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightValue() {
        return this.rightValue;
    }

    protected Object determineRightAnchor() {
        return this.variableDescriptor.isValuePotentialAnchor(this.rightValue) ? this.rightValue : this.anchorVariableSupply.getAnchor(this.rightValue);
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object rightAnchor;
        Object leftAnchor;
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        if (ObjectUtils.equals((Object)leftValue, (Object)this.rightValue) || ObjectUtils.equals((Object)this.leftEntity, (Object)this.rightValue) || ObjectUtils.equals((Object)rightEntity, (Object)leftValue)) {
            return false;
        }
        if (rightEntity == null && (leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity)) == (rightAnchor = this.determineRightAnchor())) {
            return false;
        }
        if (!this.variableDescriptor.isValueRangeEntityIndependent()) {
            ValueRange<?> rightValueRange;
            ValueRangeDescriptor valueRangeDescriptor = this.variableDescriptor.getValueRangeDescriptor();
            Solution workingSolution = scoreDirector.getWorkingSolution();
            if (rightEntity != null && !(rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution, rightEntity)).contains(leftValue)) {
                return false;
            }
            ValueRange<?> leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.leftEntity);
            if (!leftValueRange.contains(this.rightValue)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
        Object rightAnchor = this.determineRightAnchor();
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        if (leftAnchor != rightAnchor) {
            return new TailChainSwapMove(this.variableDescriptor, this.inverseVariableSupply, this.anchorVariableSupply, this.leftEntity, leftValue);
        }
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        if (rightEntity != null) {
            return new TailChainSwapMove(this.variableDescriptor, this.inverseVariableSupply, this.anchorVariableSupply, rightEntity, this.rightValue);
        }
        throw new IllegalStateException("Impossible state, because isMoveDoable() should not return true.");
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
        Object rightAnchor = this.determineRightAnchor();
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        if (leftAnchor != rightAnchor) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, this.leftEntity, this.rightValue);
            if (rightEntity != null) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, rightEntity, leftValue);
            }
        } else {
            Object lastEntityInChainOrLeftEntity = this.findLastEntityInChainOrLeftEntity();
            if (lastEntityInChainOrLeftEntity == this.leftEntity) {
                Object leftNextEntity = this.inverseVariableSupply.getInverseSingleton(this.leftEntity);
                scoreDirector.changeVariableFacade(this.variableDescriptor, this.leftEntity, this.rightValue);
                this.reverseChain(scoreDirector, leftValue, this.leftEntity, rightEntity);
                if (leftNextEntity != null) {
                    scoreDirector.changeVariableFacade(this.variableDescriptor, leftNextEntity, rightEntity);
                }
            } else {
                Object lastEntityInChain = lastEntityInChainOrLeftEntity;
                Object leftNextEntity = this.inverseVariableSupply.getInverseSingleton(this.leftEntity);
                Object entityAfterAnchor = this.inverseVariableSupply.getInverseSingleton(leftAnchor);
                this.reverseChain(scoreDirector, leftValue, this.leftEntity, entityAfterAnchor);
                scoreDirector.changeVariableFacade(this.variableDescriptor, this.leftEntity, this.rightValue);
                this.reverseChain(scoreDirector, lastEntityInChain, leftAnchor, rightEntity);
                scoreDirector.changeVariableFacade(this.variableDescriptor, leftNextEntity, rightEntity);
            }
        }
    }

    protected Object findLastEntityInChainOrLeftEntity() {
        Object entity = this.rightValue;
        while (entity != this.leftEntity) {
            Object nextEntity = this.inverseVariableSupply.getInverseSingleton(entity);
            if (nextEntity == null) {
                return entity;
            }
            entity = nextEntity;
        }
        return this.leftEntity;
    }

    protected void reverseChain(ScoreDirector scoreDirector, Object fromValue, Object fromEntity, Object toEntity) {
        Object entity = fromValue;
        Object newValue = fromEntity;
        while (newValue != toEntity) {
            Object oldValue = this.variableDescriptor.getValue(entity);
            scoreDirector.changeVariableFacade(this.variableDescriptor, entity, newValue);
            newValue = entity;
            entity = oldValue;
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        return Arrays.asList(this.leftEntity, rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        return Arrays.asList(leftValue, this.rightValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TailChainSwapMove) {
            TailChainSwapMove other = (TailChainSwapMove)o;
            return new EqualsBuilder().append(this.leftEntity, other.leftEntity).append(this.rightValue, other.rightValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftEntity).append(this.rightValue).toHashCode();
    }

    public String toString() {
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        return this.leftEntity + " {" + leftValue + "} <-tailChainSwap-> " + rightEntity + " {" + this.rightValue + "}";
    }
}

