/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class HardSoftBigDecimalScore
extends AbstractScore<HardSoftBigDecimalScore>
implements FeasibilityScore<HardSoftBigDecimalScore> {
    public static final HardSoftBigDecimalScore ZERO = new HardSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final BigDecimal hardScore;
    private final BigDecimal softScore;

    public static HardSoftBigDecimalScore parseScore(String scoreString) {
        String[] scoreTokens = HardSoftBigDecimalScore.parseScoreTokens(HardSoftBigDecimalScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        int initScore = HardSoftBigDecimalScore.parseInitScore(HardSoftBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal hardScore = HardSoftBigDecimalScore.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, scoreTokens[1]);
        BigDecimal softScore = HardSoftBigDecimalScore.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, scoreTokens[2]);
        return HardSoftBigDecimalScore.valueOfUninitialized(initScore, hardScore, softScore);
    }

    public static HardSoftBigDecimalScore valueOfUninitialized(int initScore, BigDecimal hardScore, BigDecimal softScore) {
        return new HardSoftBigDecimalScore(initScore, hardScore, softScore);
    }

    public static HardSoftBigDecimalScore valueOf(BigDecimal hardScore, BigDecimal softScore) {
        return new HardSoftBigDecimalScore(0, hardScore, softScore);
    }

    private HardSoftBigDecimalScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = null;
        this.softScore = null;
    }

    private HardSoftBigDecimalScore(int initScore, BigDecimal hardScore, BigDecimal softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardSoftBigDecimalScore toInitializedScore() {
        return this.initScore == 0 ? this : new HardSoftBigDecimalScore(0, this.hardScore, this.softScore);
    }

    @Override
    public HardSoftBigDecimalScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new HardSoftBigDecimalScore(newInitScore, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore.compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public HardSoftBigDecimalScore add(HardSoftBigDecimalScore augment) {
        return new HardSoftBigDecimalScore(this.initScore + augment.getInitScore(), this.hardScore.add(augment.getHardScore()), this.softScore.add(augment.getSoftScore()));
    }

    @Override
    public HardSoftBigDecimalScore subtract(HardSoftBigDecimalScore subtrahend) {
        return new HardSoftBigDecimalScore(this.initScore - subtrahend.getInitScore(), this.hardScore.subtract(subtrahend.getHardScore()), this.softScore.subtract(subtrahend.getSoftScore()));
    }

    @Override
    public HardSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return new HardSoftBigDecimalScore((int)Math.floor((double)this.initScore * multiplicand), this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return new HardSoftBigDecimalScore((int)Math.floor((double)this.initScore / divisor), this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return new HardSoftBigDecimalScore((int)Math.floor(Math.pow(this.initScore, exponent)), this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore negate() {
        return new HardSoftBigDecimalScore(-this.initScore, this.hardScore.negate(), this.softScore.negate());
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftBigDecimalScore) {
            HardSoftBigDecimalScore other = (HardSoftBigDecimalScore)o;
            return this.initScore == other.getInitScore() && this.hardScore.stripTrailingZeros().equals(other.getHardScore().stripTrailingZeros()) && this.softScore.stripTrailingZeros().equals(other.getSoftScore().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return ((629 + this.initScore) * 37 + this.hardScore.stripTrailingZeros().hashCode()) * 37 + this.softScore.stripTrailingZeros().hashCode();
    }

    @Override
    public int compareTo(HardSoftBigDecimalScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        int hardScoreComparison = this.hardScore.compareTo(other.getHardScore());
        if (hardScoreComparison != 0) {
            return hardScoreComparison;
        }
        return this.softScore.compareTo(other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, HARD_LABEL, SOFT_LABEL);
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof HardSoftBigDecimalScore;
    }
}

