/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftBigDecimalScoreHolder
extends AbstractScoreHolder {
    protected BigDecimal hardScore = null;
    protected BigDecimal softScore = null;

    public HardSoftBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardSoftBigDecimalScore.ZERO);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
        }, () -> HardSoftBigDecimalScore.valueOf(hardWeight, BigDecimal.ZERO));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight) {
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardSoftBigDecimalScore.valueOf(BigDecimal.ZERO, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal softWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardSoftBigDecimalScore.valueOf(hardWeight, softWeight));
    }

    @Override
    public Score extractScore(int initScore) {
        return HardSoftBigDecimalScore.valueOfUninitialized(initScore, this.hardScore == null ? BigDecimal.ZERO : this.hardScore, this.softScore == null ? BigDecimal.ZERO : this.softScore);
    }
}

