/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.decorator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;

public class SelectedCountLimitMoveSelector
extends AbstractMoveSelector {
    protected final MoveSelector childMoveSelector;
    protected final long selectedCountLimit;

    public SelectedCountLimitMoveSelector(MoveSelector childMoveSelector, long selectedCountLimit) {
        this.childMoveSelector = childMoveSelector;
        this.selectedCountLimit = selectedCountLimit;
        if (selectedCountLimit < 0L) {
            throw new IllegalArgumentException("The selector (" + this + ") has a negative selectedCountLimit (" + selectedCountLimit + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize() {
        long childSize = this.childMoveSelector.getSize();
        return Math.min(this.selectedCountLimit, childSize);
    }

    @Override
    public Iterator<Move> iterator() {
        return new SelectedCountLimitMoveIterator(this.childMoveSelector.iterator());
    }

    public String toString() {
        return "SelectedCountLimit(" + this.childMoveSelector + ")";
    }

    private class SelectedCountLimitMoveIterator
    extends SelectionIterator<Move> {
        private final Iterator<Move> childMoveIterator;
        private long selectedSize;

        public SelectedCountLimitMoveIterator(Iterator<Move> childMoveIterator) {
            this.childMoveIterator = childMoveIterator;
            this.selectedSize = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.selectedSize < SelectedCountLimitMoveSelector.this.selectedCountLimit && this.childMoveIterator.hasNext();
        }

        @Override
        public Move next() {
            if (this.selectedSize >= SelectedCountLimitMoveSelector.this.selectedCountLimit) {
                throw new NoSuchElementException();
            }
            ++this.selectedSize;
            return this.childMoveIterator.next();
        }
    }
}

