/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.chained;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.random.RandomUtils;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultSubChainSelector
extends AbstractSelector
implements SubChainSelector,
SelectionCacheLifecycleListener {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntityIndependentValueSelector valueSelector;
    protected final boolean randomSelection;
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected final int minimumSubChainSize;
    protected final int maximumSubChainSize;
    protected List<SubChain> anchorTrailingChainList = null;

    public DefaultSubChainSelector(EntityIndependentValueSelector valueSelector, boolean randomSelection, int minimumSubChainSize, int maximumSubChainSize) {
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        if (!valueSelector.getVariableDescriptor().isChained()) {
            throw new IllegalArgumentException("The selector (" + this + ")'s valueSelector (" + valueSelector + ") must have a chained variableDescriptor chained (" + valueSelector.getVariableDescriptor().isChained() + ").");
        }
        if (valueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + valueSelector + ") with neverEnding (" + valueSelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(valueSelector);
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        this.minimumSubChainSize = minimumSubChainSize;
        this.maximumSubChainSize = maximumSubChainSize;
        if (minimumSubChainSize < 1) {
            throw new IllegalStateException("The selector (" + this + ")'s minimumSubChainSize (" + minimumSubChainSize + ") must be at least 1.");
        }
        if (minimumSubChainSize > maximumSubChainSize) {
            throw new IllegalStateException("The minimumSubChainSize (" + minimumSubChainSize + ") must be at least maximumSubChainSize (" + maximumSubChainSize + ").");
        }
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.valueSelector.getVariableDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(variableDescriptor));
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        InnerScoreDirector scoreDirector = solverScope.getScoreDirector();
        GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        long valueSize = this.valueSelector.getSize();
        if (valueSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + this.valueSelector + ") with valueSize (" + valueSize + ") which is higher than Integer.MAX_VALUE.");
        }
        ArrayList anchorList = new ArrayList();
        for (Object value : this.valueSelector) {
            if (!variableDescriptor.isValuePotentialAnchor(value)) continue;
            anchorList.add(value);
        }
        this.anchorTrailingChainList = new ArrayList<SubChain>(anchorList.size());
        int anchorChainInitialCapacity = (int)valueSize / anchorList.size() + 1;
        for (Object anchor : anchorList) {
            ArrayList<Object> anchorChain = new ArrayList<Object>(anchorChainInitialCapacity);
            Object trailingEntity = this.inverseVariableSupply.getInverseSingleton(anchor);
            while (trailingEntity != null) {
                anchorChain.add(trailingEntity);
                trailingEntity = this.inverseVariableSupply.getInverseSingleton(trailingEntity);
            }
            if (anchorChain.size() < this.minimumSubChainSize) continue;
            this.anchorTrailingChainList.add(new SubChain(anchorChain));
        }
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.anchorTrailingChainList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long selectionSize = 0L;
        for (SubChain anchorTrailingChain : this.anchorTrailingChainList) {
            selectionSize += this.calculateSubChainSelectionSize(anchorTrailingChain);
        }
        return selectionSize;
    }

    protected long calculateSubChainSelectionSize(SubChain anchorTrailingChain) {
        long anchorTrailingChainSize = anchorTrailingChain.getSize();
        long n = anchorTrailingChainSize - (long)this.minimumSubChainSize + 1L;
        long m = (long)this.maximumSubChainSize >= anchorTrailingChainSize ? 0L : anchorTrailingChainSize - (long)this.maximumSubChainSize;
        return n * (n + 1L) / 2L - m * (m + 1L) / 2L;
    }

    @Override
    public Iterator<SubChain> iterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.listIterator());
        }
        return new RandomSubChainIterator();
    }

    @Override
    public ListIterator<SubChain> listIterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.listIterator());
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<SubChain> listIterator(int index) {
        if (!this.randomSelection) {
            OriginalSubChainIterator it = new OriginalSubChainIterator(this.anchorTrailingChainList.listIterator());
            for (int i = 0; i < index; ++i) {
                it.next();
            }
            return it;
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelector + ")";
    }

    private class RandomSubChainIterator
    extends UpcomingSelectionIterator<SubChain> {
        private RandomSubChainIterator() {
            if (DefaultSubChainSelector.this.anchorTrailingChainList.isEmpty()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            }
        }

        @Override
        protected SubChain createUpcomingSelection() {
            long selectionIndex;
            SubChain anchorTrailingChain = this.selectAnchorTrailingChain();
            long selectionSize = DefaultSubChainSelector.this.calculateSubChainSelectionSize(anchorTrailingChain);
            long fromIndex = selectionIndex = RandomUtils.nextLong(DefaultSubChainSelector.this.workingRandom, selectionSize);
            long subChainSize = DefaultSubChainSelector.this.minimumSubChainSize;
            long countInThatSize = (long)anchorTrailingChain.getSize() - subChainSize + 1L;
            while (fromIndex >= countInThatSize) {
                fromIndex -= countInThatSize;
                ++subChainSize;
                if (--countInThatSize > 0L) continue;
                throw new IllegalStateException("Impossible if calculateSubChainSelectionSize() works correctly.");
            }
            return anchorTrailingChain.subChain((int)fromIndex, (int)(fromIndex + subChainSize));
        }

        private SubChain selectAnchorTrailingChain() {
            int anchorTrailingChainListIndex = DefaultSubChainSelector.this.workingRandom.nextInt(DefaultSubChainSelector.this.anchorTrailingChainList.size());
            return DefaultSubChainSelector.this.anchorTrailingChainList.get(anchorTrailingChainListIndex);
        }
    }

    private class OriginalSubChainIterator
    extends UpcomingSelectionIterator<SubChain>
    implements ListIterator<SubChain> {
        private final ListIterator<SubChain> anchorTrailingChainIterator;
        private List<Object> anchorTrailingChain;
        private int fromIndex;
        private int toIndex;
        private int nextListIteratorIndex;

        public OriginalSubChainIterator(ListIterator<SubChain> anchorTrailingChainIterator) {
            this.anchorTrailingChainIterator = anchorTrailingChainIterator;
            this.fromIndex = 0;
            this.toIndex = 1;
            this.anchorTrailingChain = Collections.emptyList();
            this.nextListIteratorIndex = 0;
        }

        @Override
        protected SubChain createUpcomingSelection() {
            ++this.toIndex;
            if (this.toIndex - this.fromIndex > DefaultSubChainSelector.this.maximumSubChainSize || this.toIndex > this.anchorTrailingChain.size()) {
                ++this.fromIndex;
                this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                while (this.toIndex > this.anchorTrailingChain.size()) {
                    if (!this.anchorTrailingChainIterator.hasNext()) {
                        return (SubChain)this.noUpcomingSelection();
                    }
                    this.anchorTrailingChain = this.anchorTrailingChainIterator.next().getEntityList();
                    this.fromIndex = 0;
                    this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                }
            }
            return new SubChain(this.anchorTrailingChain.subList(this.fromIndex, this.toIndex));
        }

        @Override
        public SubChain next() {
            ++this.nextListIteratorIndex;
            return (SubChain)super.next();
        }

        @Override
        public int nextIndex() {
            return this.nextListIteratorIndex;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException("The operation hasPrevious() is not supported. See https://issues.jboss.org/browse/PLANNER-37");
        }

        @Override
        public SubChain previous() {
            throw new UnsupportedOperationException("The operation previous() is not supported. See https://issues.jboss.org/browse/PLANNER-37");
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException("The operation previousIndex() is not supported. See https://issues.jboss.org/browse/PLANNER-37");
        }

        @Override
        public void set(SubChain subChain) {
            throw new UnsupportedOperationException("The optional operation set() is not supported.");
        }

        @Override
        public void add(SubChain subChain) {
            throw new UnsupportedOperationException("The optional operation add() is not supported.");
        }
    }
}

