/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.mimic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;

public class MimicRecordingValueSelector
extends AbstractValueSelector
implements ValueMimicRecorder,
EntityIndependentValueSelector {
    protected final EntityIndependentValueSelector childValueSelector;
    protected final List<MimicReplayingValueSelector> replayingValueSelectorList;

    public MimicRecordingValueSelector(EntityIndependentValueSelector childValueSelector) {
        this.childValueSelector = childValueSelector;
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        this.replayingValueSelectorList = new ArrayList<MimicReplayingValueSelector>();
    }

    @Override
    public void addMimicReplayingValueSelector(MimicReplayingValueSelector replayingEntitySelector) {
        this.replayingValueSelectorList.add(replayingEntitySelector);
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public long getSize() {
        return this.childValueSelector.getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new RecordingValueIterator(this.childValueSelector.iterator(entity));
    }

    @Override
    public Iterator<Object> iterator() {
        return new RecordingValueIterator(this.childValueSelector.iterator());
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    public String toString() {
        return "Recording(" + this.childValueSelector + ")";
    }

    private class RecordingValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;

        public RecordingValueIterator(Iterator<Object> childValueIterator) {
            this.childValueIterator = childValueIterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.childValueIterator.hasNext();
            for (MimicReplayingValueSelector replayingValueSelector : MimicRecordingValueSelector.this.replayingValueSelectorList) {
                replayingValueSelector.recordedHasNext(hasNext);
            }
            return hasNext;
        }

        @Override
        public Object next() {
            Object next = this.childValueIterator.next();
            for (MimicReplayingValueSelector replayingValueSelector : MimicRecordingValueSelector.this.replayingValueSelectorList) {
                replayingValueSelector.recordedNext(next);
            }
            return next;
        }
    }
}

