/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic;

import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicPhase;
import org.optaplanner.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultConstructionHeuristicPhase<Solution_>
extends AbstractPhase<Solution_>
implements ConstructionHeuristicPhase<Solution_> {
    protected EntityPlacer<Solution_> entityPlacer;
    protected ConstructionHeuristicDecider<Solution_> decider;
    protected final boolean skipBestSolutionCloningInSteps = true;

    public DefaultConstructionHeuristicPhase(int phaseIndex, String logIndentation, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> termination) {
        super(phaseIndex, logIndentation, bestSolutionRecaller, termination);
    }

    public void setEntityPlacer(EntityPlacer<Solution_> entityPlacer) {
        this.entityPlacer = entityPlacer;
    }

    public void setDecider(ConstructionHeuristicDecider<Solution_> decider) {
        this.decider = decider;
    }

    @Override
    public String getPhaseTypeString() {
        return "Construction Heuristics";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        ConstructionHeuristicPhaseScope<Solution_> phaseScope = new ConstructionHeuristicPhaseScope<Solution_>(solverScope);
        this.phaseStarted(phaseScope);
        for (Placement placement : this.entityPlacer) {
            ConstructionHeuristicStepScope<Solution_> stepScope = new ConstructionHeuristicStepScope<Solution_>(phaseScope);
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope, placement);
            if (stepScope.getStep() == null) {
                if (this.termination.isPhaseTerminated(phaseScope)) {
                    this.logger.trace("{}    Step index ({}), time spent ({}) terminated without picking a nextStep.", new Object[]{this.logIndentation, stepScope.getStepIndex(), stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow()});
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("{}    No doable selected move at step index ({}), time spent ({}). Terminating phase early.", new Object[]{this.logIndentation, stepScope.getStepIndex(), stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow()});
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has selected move count (" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + stepScope.getStep() + ").");
            }
            this.doStep(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            if (!this.termination.isPhaseTerminated(phaseScope)) continue;
            break;
        }
        this.phaseEnded(phaseScope);
    }

    private void doStep(ConstructionHeuristicStepScope<Solution_> stepScope) {
        Move<Solution_> step = stepScope.getStep();
        Move<Solution_> undoStep = step.doMove(stepScope.getScoreDirector());
        stepScope.setUndoStep(undoStep);
        this.predictWorkingStepScore(stepScope, step);
        stepScope.setBestScoreImproved(true);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.entityPlacer.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.entityPlacer.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(ConstructionHeuristicStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.entityPlacer.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(ConstructionHeuristicStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.entityPlacer.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow();
            this.logger.debug("{}    CH step ({}), time spent ({}), score ({}), selected move count ({}), picked move ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), timeMillisSpent, stepScope.getScore(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.bestSolutionRecaller.updateBestSolution(phaseScope.getSolverScope());
        this.entityPlacer.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Construction Heuristic phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex()});
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.entityPlacer.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

