/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.Iterator;
import java.util.ListIterator;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.AbstractCachingEntitySelector;

public class CachingEntitySelector<Solution_>
extends AbstractCachingEntitySelector<Solution_> {
    protected final boolean randomSelection;

    public CachingEntitySelector(EntitySelector<Solution_> childEntitySelector, SelectionCacheType cacheType, boolean randomSelection) {
        super(childEntitySelector, cacheType);
        this.randomSelection = randomSelection;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return this.cachedEntityList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedEntityList, this.workingRandom);
    }

    @Override
    public ListIterator<Object> listIterator() {
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator();
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return "Caching(" + this.childEntitySelector + ")";
    }
}

