/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.constraint.DefaultIndictment;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniTuple;

public final class BavetConstraintSession<Solution_, Score_ extends Score<Score_>>
implements ConstraintSession<Solution_, Score_> {
    private final boolean constraintMatchEnabled;
    private final Score_ zeroScore;
    private final ScoreInliner<Score_> scoreInliner;
    private final Map<Class<?>, BavetFromUniNode<Object>> declaredClassToNodeMap;
    private final int nodeOrderSize;
    private final Map<String, BavetScoringNode> constraintIdToScoringNodeMap;
    private final Map<Class<?>, List<BavetFromUniNode<Object>>> effectiveClassToNodeListMap;
    private final List<Queue<BavetAbstractTuple>> nodeOrderedQueueList;
    private final Map<Object, List<BavetFromUniTuple<Object>>> fromTupleListMap;

    public BavetConstraintSession(boolean constraintMatchEnabled, ScoreDefinition<Score_> scoreDefinition, Map<BavetConstraint<Solution_>, Score_> constraintToWeightMap) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.zeroScore = scoreDefinition.getZeroScore();
        this.scoreInliner = scoreDefinition.buildScoreInliner(constraintMatchEnabled);
        this.declaredClassToNodeMap = new HashMap(50);
        BavetNodeBuildPolicy buildPolicy = new BavetNodeBuildPolicy(this, constraintToWeightMap.size());
        constraintToWeightMap.forEach((constraint, constraintWeight) -> constraint.createNodes(buildPolicy, this.declaredClassToNodeMap, (Score<?>)constraintWeight));
        this.nodeOrderSize = buildPolicy.getNodeOrderMaximum() + 1;
        this.constraintIdToScoringNodeMap = buildPolicy.getConstraintIdToScoringNodeMap();
        this.effectiveClassToNodeListMap = new HashMap(this.declaredClassToNodeMap.size());
        this.nodeOrderedQueueList = new ArrayList<Queue<BavetAbstractTuple>>(this.nodeOrderSize);
        for (int i = 0; i < this.nodeOrderSize; ++i) {
            this.nodeOrderedQueueList.add(new ArrayDeque(1000));
        }
        this.fromTupleListMap = new IdentityHashMap<Object, List<BavetFromUniTuple<Object>>>(1000);
    }

    public List<BavetFromUniNode<Object>> findFromNodeList(Class<?> factClass) {
        return this.effectiveClassToNodeListMap.computeIfAbsent(factClass, key -> {
            ArrayList nodeList = new ArrayList();
            this.declaredClassToNodeMap.forEach((declaredClass, declaredNode) -> {
                if (declaredClass.isAssignableFrom(factClass)) {
                    nodeList.add(declaredNode);
                }
            });
            return nodeList;
        });
    }

    @Override
    public void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        List<BavetFromUniNode<Object>> fromNodeList = this.findFromNodeList(factClass);
        ArrayList<BavetFromUniTuple<Object>> tupleList = new ArrayList<BavetFromUniTuple<Object>>(fromNodeList.size());
        List old = this.fromTupleListMap.put(fact, tupleList);
        if (old != null) {
            throw new IllegalStateException("The fact (" + fact + ") was already inserted, so it cannot insert again.");
        }
        for (BavetFromUniNode<Object> node : fromNodeList) {
            BavetFromUniTuple<Object> tuple = node.createTuple(fact);
            tupleList.add(tuple);
            this.transitionTuple(tuple, BavetTupleState.CREATING);
        }
    }

    @Override
    public void update(Object fact) {
        List<BavetFromUniTuple<Object>> tupleList = this.fromTupleListMap.get(fact);
        if (tupleList == null) {
            throw new IllegalStateException("The fact (" + fact + ") was never inserted, so it cannot update.");
        }
        for (BavetFromUniTuple<Object> tuple : tupleList) {
            this.transitionTuple(tuple, BavetTupleState.UPDATING);
        }
    }

    @Override
    public void retract(Object fact) {
        List<BavetFromUniTuple<Object>> tupleList = this.fromTupleListMap.remove(fact);
        if (tupleList == null) {
            throw new IllegalStateException("The fact (" + fact + ") was never inserted, so it cannot retract.");
        }
        for (BavetFromUniTuple<Object> tuple : tupleList) {
            this.transitionTuple(tuple, BavetTupleState.DYING);
        }
    }

    public void transitionTuple(BavetAbstractTuple tuple, BavetTupleState newState) {
        if (tuple.isDirty()) {
            if (tuple.getState() != newState) {
                if (tuple.getState() == BavetTupleState.CREATING && newState == BavetTupleState.DYING) {
                    tuple.setState(BavetTupleState.ABORTING);
                } else if (tuple.getState() == BavetTupleState.UPDATING && newState == BavetTupleState.DYING) {
                    tuple.setState(BavetTupleState.DYING);
                } else {
                    throw new IllegalStateException("The tuple (" + tuple + ") already has a dirty state (" + (Object)((Object)tuple.getState()) + ") so it cannot transition to newState (" + (Object)((Object)newState) + ").");
                }
            }
            return;
        }
        tuple.setState(newState);
        this.nodeOrderedQueueList.get(tuple.getNodeOrder()).add(tuple);
    }

    @Override
    public Score_ calculateScore(int initScore) {
        for (int i = 0; i < this.nodeOrderSize; ++i) {
            Queue<BavetAbstractTuple> queue = this.nodeOrderedQueueList.get(i);
            BavetAbstractTuple tuple = queue.poll();
            while (tuple != null) {
                tuple.refresh();
                tuple = queue.poll();
            }
        }
        return this.scoreInliner.extractScore(initScore);
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        LinkedHashMap<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap = new LinkedHashMap<String, ConstraintMatchTotal<Score_>>(this.constraintIdToScoringNodeMap.size());
        this.constraintIdToScoringNodeMap.forEach((constraintId, scoringNode) -> {
            ConstraintMatchTotal<Score_> constraintMatchTotal = scoringNode.buildConstraintMatchTotal(this.zeroScore);
            constraintMatchTotalMap.put((String)constraintId, constraintMatchTotal);
        });
        return constraintMatchTotalMap;
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        LinkedHashMap<Object, Indictment<Score_>> indictmentMap = new LinkedHashMap<Object, Indictment<Score_>>();
        Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap = this.getConstraintMatchTotalMap();
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : constraintMatchTotalMap.values()) {
            for (ConstraintMatch<Score_> constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch.getJustificationList().stream().distinct().forEach(justification -> {
                    DefaultIndictment indictment = (DefaultIndictment)indictmentMap.computeIfAbsent(justification, k -> new DefaultIndictment<Score_>(justification, this.zeroScore));
                    indictment.addConstraintMatch(constraintMatch);
                });
            }
        }
        return indictmentMap;
    }

    @Override
    public void close() {
    }

    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    public ScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }
}

