/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Predicate2;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractGroupByMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiJoinMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniExistenceMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy0Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy1Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy1Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy1Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy1Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy2Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy2Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy2Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy2Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy2Map2CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniGroupBy2Map2CollectMutator;

final class UniRuleAssembler
extends AbstractRuleAssembler<Predicate> {
    private Predicate filterToApplyToLastPrimaryPattern = null;

    public UniRuleAssembler(DroolsVariableFactory variableFactory, ConstraintGraphNode previousNode, int expectedGroupByCount) {
        super(variableFactory, previousNode, expectedGroupByCount);
    }

    public UniRuleAssembler(DroolsVariableFactory variableFactory, int expectedGroupByCount, List<ViewItem> finishedExpressions, Variable aVariable, List<PatternDSL.PatternDef> primaryPatterns, Map<Integer, List<ViewItem>> dependentExpressionMap) {
        super(variableFactory, expectedGroupByCount, finishedExpressions, primaryPatterns, dependentExpressionMap, aVariable);
    }

    @Override
    protected void addFilterToLastPrimaryPattern(Predicate predicate) {
        this.filterToApplyToLastPrimaryPattern = this.filterToApplyToLastPrimaryPattern == null ? predicate : this.filterToApplyToLastPrimaryPattern.and(predicate);
    }

    @Override
    protected AbstractRuleAssembler join(UniRuleAssembler ruleAssembler, ConstraintGraphNode joinNode) {
        return new BiJoinMutator((AbstractConstraintModelJoiningNode)joinNode).apply(this, ruleAssembler);
    }

    @Override
    protected AbstractRuleAssembler andThenExists(AbstractConstraintModelJoiningNode joiningNode, boolean shouldExist) {
        return new UniExistenceMutator(joiningNode, shouldExist).apply(this);
    }

    @Override
    protected AbstractGroupByMutator new0Map1CollectGroupByMutator(Object collector) {
        return new UniGroupBy0Map1CollectMutator((UniConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new1Map0CollectGroupByMutator(Object mapping) {
        if (this.getExpectedGroupByCount() == 1) {
            return new UniGroupBy1Map0CollectFastMutator((Function)mapping);
        }
        return new UniGroupBy1Map0CollectMutator((Function)mapping);
    }

    @Override
    protected AbstractGroupByMutator new1Map1CollectGroupByMutator(Object mapping, Object collector) {
        if (this.getExpectedGroupByCount() == 1) {
            return new UniGroupBy1Map1CollectFastMutator((Function)mapping, (UniConstraintCollector)collector);
        }
        return new UniGroupBy1Map1CollectMutator((Function)mapping, (UniConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new2Map0CollectGroupByMutator(Object mappingA, Object mappingB) {
        if (this.getExpectedGroupByCount() == 1) {
            return new UniGroupBy2Map0CollectFastMutator((Function)mappingA, (Function)mappingB);
        }
        return new UniGroupBy2Map0CollectMutator((Function)mappingA, (Function)mappingB);
    }

    @Override
    protected AbstractGroupByMutator new2Map1CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC) {
        if (this.getExpectedGroupByCount() == 1) {
            return new UniGroupBy2Map1CollectFastMutator((Function)mappingA, (Function)mappingB, (UniConstraintCollector)collectorC);
        }
        return new UniGroupBy2Map1CollectMutator((Function)mappingA, (Function)mappingB, (UniConstraintCollector)collectorC);
    }

    @Override
    protected AbstractGroupByMutator new2Map2CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC, Object collectorD) {
        if (this.getExpectedGroupByCount() == 1) {
            return new UniGroupBy2Map2CollectFastMutator((Function)mappingA, (Function)mappingB, (UniConstraintCollector)collectorC, (UniConstraintCollector)collectorD);
        }
        return new UniGroupBy2Map2CollectMutator((Function)mappingA, (Function)mappingB, (UniConstraintCollector)collectorC, (UniConstraintCollector)collectorD);
    }

    @Override
    protected ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable ... variables) {
        ConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntFunction intMatchWeighter = (ToIntFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> UniRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, intMatchWeighter.applyAsInt(a)));
            }
            case LONG: {
                ToLongFunction longMatchWeighter = (ToLongFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> UniRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, longMatchWeighter.applyAsLong(a)));
            }
            case BIG_DECIMAL: {
                Function bigDecimalMatchWeighter = (Function)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> UniRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal, (Variable)variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> UniRuleAssembler.impactScore((Drools)drools, (AbstractScoreHolder)scoreHolder));
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }

    @Override
    protected void applyFilterToLastPrimaryPattern() {
        if (this.filterToApplyToLastPrimaryPattern == null) {
            return;
        }
        Predicate predicate = this.filterToApplyToLastPrimaryPattern;
        this.getLastPrimaryPattern().expr("Filter using " + predicate, this.getVariable(0), (Predicate2 & Serializable)(fact, a) -> predicate.test(a));
        this.filterToApplyToLastPrimaryPattern = null;
    }
}

