/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver.termination;

import java.time.Duration;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.solver.termination.TerminationCompositionStyle;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.io.jaxb.adapter.JaxbDurationAdapter;
import org.optaplanner.core.impl.solver.termination.Termination;

@XmlType(propOrder={"terminationClass", "terminationCompositionStyle", "spentLimit", "millisecondsSpentLimit", "secondsSpentLimit", "minutesSpentLimit", "hoursSpentLimit", "daysSpentLimit", "unimprovedSpentLimit", "unimprovedMillisecondsSpentLimit", "unimprovedSecondsSpentLimit", "unimprovedMinutesSpentLimit", "unimprovedHoursSpentLimit", "unimprovedDaysSpentLimit", "unimprovedScoreDifferenceThreshold", "bestScoreLimit", "bestScoreFeasible", "stepCountLimit", "unimprovedStepCountLimit", "scoreCalculationCountLimit", "terminationConfigList"})
public class TerminationConfig
extends AbstractConfig<TerminationConfig> {
    private Class<? extends Termination> terminationClass = null;
    private TerminationCompositionStyle terminationCompositionStyle = null;
    @XmlJavaTypeAdapter(value=JaxbDurationAdapter.class)
    private Duration spentLimit = null;
    private Long millisecondsSpentLimit = null;
    private Long secondsSpentLimit = null;
    private Long minutesSpentLimit = null;
    private Long hoursSpentLimit = null;
    private Long daysSpentLimit = null;
    @XmlJavaTypeAdapter(value=JaxbDurationAdapter.class)
    private Duration unimprovedSpentLimit = null;
    private Long unimprovedMillisecondsSpentLimit = null;
    private Long unimprovedSecondsSpentLimit = null;
    private Long unimprovedMinutesSpentLimit = null;
    private Long unimprovedHoursSpentLimit = null;
    private Long unimprovedDaysSpentLimit = null;
    private String unimprovedScoreDifferenceThreshold = null;
    private String bestScoreLimit = null;
    private Boolean bestScoreFeasible = null;
    private Integer stepCountLimit = null;
    private Integer unimprovedStepCountLimit = null;
    private Long scoreCalculationCountLimit = null;
    @XmlElement(name="termination")
    private List<TerminationConfig> terminationConfigList = null;

    public Class<? extends Termination> getTerminationClass() {
        return this.terminationClass;
    }

    public void setTerminationClass(Class<? extends Termination> terminationClass) {
        this.terminationClass = terminationClass;
    }

    public TerminationCompositionStyle getTerminationCompositionStyle() {
        return this.terminationCompositionStyle;
    }

    public void setTerminationCompositionStyle(TerminationCompositionStyle terminationCompositionStyle) {
        this.terminationCompositionStyle = terminationCompositionStyle;
    }

    public Duration getSpentLimit() {
        return this.spentLimit;
    }

    public void setSpentLimit(Duration spentLimit) {
        this.spentLimit = spentLimit;
    }

    public Long getMillisecondsSpentLimit() {
        return this.millisecondsSpentLimit;
    }

    public void setMillisecondsSpentLimit(Long millisecondsSpentLimit) {
        this.millisecondsSpentLimit = millisecondsSpentLimit;
    }

    public Long getSecondsSpentLimit() {
        return this.secondsSpentLimit;
    }

    public void setSecondsSpentLimit(Long secondsSpentLimit) {
        this.secondsSpentLimit = secondsSpentLimit;
    }

    public Long getMinutesSpentLimit() {
        return this.minutesSpentLimit;
    }

    public void setMinutesSpentLimit(Long minutesSpentLimit) {
        this.minutesSpentLimit = minutesSpentLimit;
    }

    public Long getHoursSpentLimit() {
        return this.hoursSpentLimit;
    }

    public void setHoursSpentLimit(Long hoursSpentLimit) {
        this.hoursSpentLimit = hoursSpentLimit;
    }

    public Long getDaysSpentLimit() {
        return this.daysSpentLimit;
    }

    public void setDaysSpentLimit(Long daysSpentLimit) {
        this.daysSpentLimit = daysSpentLimit;
    }

    public Duration getUnimprovedSpentLimit() {
        return this.unimprovedSpentLimit;
    }

    public void setUnimprovedSpentLimit(Duration unimprovedSpentLimit) {
        this.unimprovedSpentLimit = unimprovedSpentLimit;
    }

    public Long getUnimprovedMillisecondsSpentLimit() {
        return this.unimprovedMillisecondsSpentLimit;
    }

    public void setUnimprovedMillisecondsSpentLimit(Long unimprovedMillisecondsSpentLimit) {
        this.unimprovedMillisecondsSpentLimit = unimprovedMillisecondsSpentLimit;
    }

    public Long getUnimprovedSecondsSpentLimit() {
        return this.unimprovedSecondsSpentLimit;
    }

    public void setUnimprovedSecondsSpentLimit(Long unimprovedSecondsSpentLimit) {
        this.unimprovedSecondsSpentLimit = unimprovedSecondsSpentLimit;
    }

    public Long getUnimprovedMinutesSpentLimit() {
        return this.unimprovedMinutesSpentLimit;
    }

    public void setUnimprovedMinutesSpentLimit(Long unimprovedMinutesSpentLimit) {
        this.unimprovedMinutesSpentLimit = unimprovedMinutesSpentLimit;
    }

    public Long getUnimprovedHoursSpentLimit() {
        return this.unimprovedHoursSpentLimit;
    }

    public void setUnimprovedHoursSpentLimit(Long unimprovedHoursSpentLimit) {
        this.unimprovedHoursSpentLimit = unimprovedHoursSpentLimit;
    }

    public Long getUnimprovedDaysSpentLimit() {
        return this.unimprovedDaysSpentLimit;
    }

    public void setUnimprovedDaysSpentLimit(Long unimprovedDaysSpentLimit) {
        this.unimprovedDaysSpentLimit = unimprovedDaysSpentLimit;
    }

    public String getUnimprovedScoreDifferenceThreshold() {
        return this.unimprovedScoreDifferenceThreshold;
    }

    public void setUnimprovedScoreDifferenceThreshold(String unimprovedScoreDifferenceThreshold) {
        this.unimprovedScoreDifferenceThreshold = unimprovedScoreDifferenceThreshold;
    }

    public String getBestScoreLimit() {
        return this.bestScoreLimit;
    }

    public void setBestScoreLimit(String bestScoreLimit) {
        this.bestScoreLimit = bestScoreLimit;
    }

    public Boolean getBestScoreFeasible() {
        return this.bestScoreFeasible;
    }

    public void setBestScoreFeasible(Boolean bestScoreFeasible) {
        this.bestScoreFeasible = bestScoreFeasible;
    }

    public Integer getStepCountLimit() {
        return this.stepCountLimit;
    }

    public void setStepCountLimit(Integer stepCountLimit) {
        this.stepCountLimit = stepCountLimit;
    }

    public Integer getUnimprovedStepCountLimit() {
        return this.unimprovedStepCountLimit;
    }

    public void setUnimprovedStepCountLimit(Integer unimprovedStepCountLimit) {
        this.unimprovedStepCountLimit = unimprovedStepCountLimit;
    }

    public Long getScoreCalculationCountLimit() {
        return this.scoreCalculationCountLimit;
    }

    public void setScoreCalculationCountLimit(Long scoreCalculationCountLimit) {
        this.scoreCalculationCountLimit = scoreCalculationCountLimit;
    }

    public List<TerminationConfig> getTerminationConfigList() {
        return this.terminationConfigList;
    }

    public void setTerminationConfigList(List<TerminationConfig> terminationConfigList) {
        this.terminationConfigList = terminationConfigList;
    }

    public TerminationConfig withTerminationClass(Class<? extends Termination> terminationClass) {
        this.terminationClass = terminationClass;
        return this;
    }

    public TerminationConfig withTerminationCompositionStyle(TerminationCompositionStyle terminationCompositionStyle) {
        this.terminationCompositionStyle = terminationCompositionStyle;
        return this;
    }

    public TerminationConfig withSpentLimit(Duration spentLimit) {
        this.spentLimit = spentLimit;
        return this;
    }

    public TerminationConfig withMillisecondsSpentLimit(Long millisecondsSpentLimit) {
        this.millisecondsSpentLimit = millisecondsSpentLimit;
        return this;
    }

    public TerminationConfig withSecondsSpentLimit(Long secondsSpentLimit) {
        this.secondsSpentLimit = secondsSpentLimit;
        return this;
    }

    public TerminationConfig withMinutesSpentLimit(Long minutesSpentLimit) {
        this.minutesSpentLimit = minutesSpentLimit;
        return this;
    }

    public TerminationConfig withHoursSpentLimit(Long hoursSpentLimit) {
        this.hoursSpentLimit = hoursSpentLimit;
        return this;
    }

    public TerminationConfig withDaysSpentLimit(Long daysSpentLimit) {
        this.daysSpentLimit = daysSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedSpentLimit(Duration unimprovedSpentLimit) {
        this.unimprovedSpentLimit = unimprovedSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedMillisecondsSpentLimit(Long unimprovedMillisecondsSpentLimit) {
        this.unimprovedMillisecondsSpentLimit = unimprovedMillisecondsSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedSecondsSpentLimit(Long unimprovedSecondsSpentLimit) {
        this.unimprovedSecondsSpentLimit = unimprovedSecondsSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedMinutesSpentLimit(Long unimprovedMinutesSpentLimit) {
        this.unimprovedMinutesSpentLimit = unimprovedMinutesSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedHoursSpentLimit(Long unimprovedHoursSpentLimit) {
        this.unimprovedHoursSpentLimit = unimprovedHoursSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedDaysSpentLimit(Long unimprovedDaysSpentLimit) {
        this.unimprovedDaysSpentLimit = unimprovedDaysSpentLimit;
        return this;
    }

    public TerminationConfig withUnimprovedScoreDifferenceThreshold(String unimprovedScoreDifferenceThreshold) {
        this.unimprovedScoreDifferenceThreshold = unimprovedScoreDifferenceThreshold;
        return this;
    }

    public TerminationConfig withBestScoreLimit(String bestScoreLimit) {
        this.bestScoreLimit = bestScoreLimit;
        return this;
    }

    public TerminationConfig withBestScoreFeasible(Boolean bestScoreFeasible) {
        this.bestScoreFeasible = bestScoreFeasible;
        return this;
    }

    public TerminationConfig withStepCountLimit(Integer stepCountLimit) {
        this.stepCountLimit = stepCountLimit;
        return this;
    }

    public TerminationConfig withUnimprovedStepCountLimit(Integer unimprovedStepCountLimit) {
        this.unimprovedStepCountLimit = unimprovedStepCountLimit;
        return this;
    }

    public TerminationConfig withScoreCalculationCountLimit(Long scoreCalculationCountLimit) {
        this.scoreCalculationCountLimit = scoreCalculationCountLimit;
        return this;
    }

    public TerminationConfig withTerminationConfigList(List<TerminationConfig> terminationConfigList) {
        this.terminationConfigList = terminationConfigList;
        return this;
    }

    public void overwriteSpentLimit(Duration spentLimit) {
        this.setSpentLimit(spentLimit);
        this.setMillisecondsSpentLimit(null);
        this.setSecondsSpentLimit(null);
        this.setMinutesSpentLimit(null);
        this.setHoursSpentLimit(null);
        this.setDaysSpentLimit(null);
    }

    public Long calculateTimeMillisSpentLimit() {
        if (this.millisecondsSpentLimit == null && this.secondsSpentLimit == null && this.minutesSpentLimit == null && this.hoursSpentLimit == null && this.daysSpentLimit == null) {
            if (this.spentLimit != null) {
                if (this.spentLimit.getNano() % 1000 != 0) {
                    throw new IllegalArgumentException("The termination spentLimit (" + this.spentLimit + ") cannot use nanoseconds.");
                }
                return this.spentLimit.toMillis();
            }
            return null;
        }
        if (this.spentLimit != null) {
            throw new IllegalArgumentException("The termination spentLimit (" + this.spentLimit + ") cannot be combined with millisecondsSpentLimit (" + this.millisecondsSpentLimit + "), secondsSpentLimit" + this.secondsSpentLimit + "), minutesSpentLimit" + this.minutesSpentLimit + "), hoursSpentLimit" + this.hoursSpentLimit + ") or daysSpentLimit" + this.daysSpentLimit + ").");
        }
        long timeMillisSpentLimit = 0L;
        if (this.millisecondsSpentLimit != null) {
            if (this.millisecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination millisecondsSpentLimit (" + this.millisecondsSpentLimit + ") cannot be negative.");
            }
            timeMillisSpentLimit += this.millisecondsSpentLimit.longValue();
        }
        if (this.secondsSpentLimit != null) {
            if (this.secondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination secondsSpentLimit (" + this.secondsSpentLimit + ") cannot be negative.");
            }
            timeMillisSpentLimit += this.secondsSpentLimit * 1000L;
        }
        if (this.minutesSpentLimit != null) {
            if (this.minutesSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination minutesSpentLimit (" + this.minutesSpentLimit + ") cannot be negative.");
            }
            timeMillisSpentLimit += this.minutesSpentLimit * 60000L;
        }
        if (this.hoursSpentLimit != null) {
            if (this.hoursSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination hoursSpentLimit (" + this.hoursSpentLimit + ") cannot be negative.");
            }
            timeMillisSpentLimit += this.hoursSpentLimit * 3600000L;
        }
        if (this.daysSpentLimit != null) {
            if (this.daysSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination daysSpentLimit (" + this.daysSpentLimit + ") cannot be negative.");
            }
            timeMillisSpentLimit += this.daysSpentLimit * 86400000L;
        }
        return timeMillisSpentLimit;
    }

    public void shortenTimeMillisSpentLimit(long timeMillisSpentLimit) {
        Long oldLimit = this.calculateTimeMillisSpentLimit();
        if (oldLimit == null || timeMillisSpentLimit < oldLimit) {
            this.spentLimit = null;
            this.millisecondsSpentLimit = timeMillisSpentLimit;
            this.secondsSpentLimit = null;
            this.minutesSpentLimit = null;
            this.hoursSpentLimit = null;
            this.daysSpentLimit = null;
        }
    }

    public void overwriteUnimprovedSpentLimit(Duration unimprovedSpentLimit) {
        this.setUnimprovedSpentLimit(unimprovedSpentLimit);
        this.setUnimprovedMillisecondsSpentLimit(null);
        this.setUnimprovedSecondsSpentLimit(null);
        this.setUnimprovedMinutesSpentLimit(null);
        this.setUnimprovedHoursSpentLimit(null);
        this.setUnimprovedDaysSpentLimit(null);
    }

    public Long calculateUnimprovedTimeMillisSpentLimit() {
        if (this.unimprovedMillisecondsSpentLimit == null && this.unimprovedSecondsSpentLimit == null && this.unimprovedMinutesSpentLimit == null && this.unimprovedHoursSpentLimit == null) {
            if (this.unimprovedSpentLimit != null) {
                if (this.unimprovedSpentLimit.getNano() % 1000 != 0) {
                    throw new IllegalArgumentException("The termination unimprovedSpentLimit (" + this.unimprovedSpentLimit + ") cannot use nanoseconds.");
                }
                return this.unimprovedSpentLimit.toMillis();
            }
            return null;
        }
        if (this.unimprovedSpentLimit != null) {
            throw new IllegalArgumentException("The termination unimprovedSpentLimit (" + this.unimprovedSpentLimit + ") cannot be combined with unimprovedMillisecondsSpentLimit (" + this.unimprovedMillisecondsSpentLimit + "), unimprovedSecondsSpentLimit" + this.unimprovedSecondsSpentLimit + "), unimprovedMinutesSpentLimit" + this.unimprovedMinutesSpentLimit + "), unimprovedHoursSpentLimit" + this.unimprovedHoursSpentLimit + ").");
        }
        long unimprovedTimeMillisSpentLimit = 0L;
        if (this.unimprovedMillisecondsSpentLimit != null) {
            if (this.unimprovedMillisecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination unimprovedMillisecondsSpentLimit (" + this.unimprovedMillisecondsSpentLimit + ") cannot be negative.");
            }
            unimprovedTimeMillisSpentLimit += this.unimprovedMillisecondsSpentLimit.longValue();
        }
        if (this.unimprovedSecondsSpentLimit != null) {
            if (this.unimprovedSecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination unimprovedSecondsSpentLimit (" + this.unimprovedSecondsSpentLimit + ") cannot be negative.");
            }
            unimprovedTimeMillisSpentLimit += this.unimprovedSecondsSpentLimit * 1000L;
        }
        if (this.unimprovedMinutesSpentLimit != null) {
            if (this.unimprovedMinutesSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination unimprovedMinutesSpentLimit (" + this.unimprovedMinutesSpentLimit + ") cannot be negative.");
            }
            unimprovedTimeMillisSpentLimit += this.unimprovedMinutesSpentLimit * 60000L;
        }
        if (this.unimprovedHoursSpentLimit != null) {
            if (this.unimprovedHoursSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination unimprovedHoursSpentLimit (" + this.unimprovedHoursSpentLimit + ") cannot be negative.");
            }
            unimprovedTimeMillisSpentLimit += this.unimprovedHoursSpentLimit * 3600000L;
        }
        if (this.unimprovedDaysSpentLimit != null) {
            if (this.unimprovedDaysSpentLimit < 0L) {
                throw new IllegalArgumentException("The termination unimprovedDaysSpentLimit (" + this.unimprovedDaysSpentLimit + ") cannot be negative.");
            }
            unimprovedTimeMillisSpentLimit += this.unimprovedDaysSpentLimit * 86400000L;
        }
        return unimprovedTimeMillisSpentLimit;
    }

    @Override
    public TerminationConfig inherit(TerminationConfig inheritedConfig) {
        this.terminationClass = ConfigUtils.inheritOverwritableProperty(this.terminationClass, inheritedConfig.getTerminationClass());
        this.terminationCompositionStyle = ConfigUtils.inheritOverwritableProperty(this.terminationCompositionStyle, inheritedConfig.getTerminationCompositionStyle());
        this.spentLimit = ConfigUtils.inheritOverwritableProperty(this.spentLimit, inheritedConfig.getSpentLimit());
        this.millisecondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.millisecondsSpentLimit, inheritedConfig.getMillisecondsSpentLimit());
        this.secondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.secondsSpentLimit, inheritedConfig.getSecondsSpentLimit());
        this.minutesSpentLimit = ConfigUtils.inheritOverwritableProperty(this.minutesSpentLimit, inheritedConfig.getMinutesSpentLimit());
        this.hoursSpentLimit = ConfigUtils.inheritOverwritableProperty(this.hoursSpentLimit, inheritedConfig.getHoursSpentLimit());
        this.daysSpentLimit = ConfigUtils.inheritOverwritableProperty(this.daysSpentLimit, inheritedConfig.getDaysSpentLimit());
        this.unimprovedSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedSpentLimit, inheritedConfig.getUnimprovedSpentLimit());
        this.unimprovedMillisecondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedMillisecondsSpentLimit, inheritedConfig.getUnimprovedMillisecondsSpentLimit());
        this.unimprovedSecondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedSecondsSpentLimit, inheritedConfig.getUnimprovedSecondsSpentLimit());
        this.unimprovedMinutesSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedMinutesSpentLimit, inheritedConfig.getUnimprovedMinutesSpentLimit());
        this.unimprovedHoursSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedHoursSpentLimit, inheritedConfig.getUnimprovedHoursSpentLimit());
        this.unimprovedDaysSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedDaysSpentLimit, inheritedConfig.getUnimprovedDaysSpentLimit());
        this.unimprovedScoreDifferenceThreshold = ConfigUtils.inheritOverwritableProperty(this.unimprovedScoreDifferenceThreshold, inheritedConfig.getUnimprovedScoreDifferenceThreshold());
        this.bestScoreLimit = ConfigUtils.inheritOverwritableProperty(this.bestScoreLimit, inheritedConfig.getBestScoreLimit());
        this.bestScoreFeasible = ConfigUtils.inheritOverwritableProperty(this.bestScoreFeasible, inheritedConfig.getBestScoreFeasible());
        this.stepCountLimit = ConfigUtils.inheritOverwritableProperty(this.stepCountLimit, inheritedConfig.getStepCountLimit());
        this.unimprovedStepCountLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedStepCountLimit, inheritedConfig.getUnimprovedStepCountLimit());
        this.scoreCalculationCountLimit = ConfigUtils.inheritOverwritableProperty(this.scoreCalculationCountLimit, inheritedConfig.getScoreCalculationCountLimit());
        this.terminationConfigList = ConfigUtils.inheritMergeableListConfig(this.terminationConfigList, inheritedConfig.getTerminationConfigList());
        return this;
    }

    @Override
    public TerminationConfig copyConfig() {
        return new TerminationConfig().inherit(this);
    }
}

