/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Consumer;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;

public class GizmoMemberDescriptor {
    String name;
    Object memberDescriptor;
    Class<?> declaringClass;
    AnnotatedElement annotatedElement;
    Optional<MethodDescriptor> setter;
    Type type;

    public GizmoMemberDescriptor(Member member) {
        this.declaringClass = member.getDeclaringClass();
        if (!Modifier.isPublic(member.getModifiers())) {
            throw new IllegalStateException("Member (" + member.getName() + ") of class (" + member.getDeclaringClass().getName() + ") is not public and domainAccessType is GIZMO.\n" + (member instanceof Field ? "Maybe put the annotations onto the public getter of the field.\n" : "") + "Maybe use domainAccessType REFLECTION instead of GIZMO.");
        }
        if (member instanceof Field) {
            this.memberDescriptor = FieldDescriptor.of((Field)((Field)member));
            this.name = member.getName();
            this.annotatedElement = (Field)member;
            this.type = ((Field)member).getGenericType();
            this.setter = GizmoMemberDescriptor.lookupSetter(this.memberDescriptor, this.declaringClass, this.name);
        } else if (member instanceof Method) {
            this.memberDescriptor = MethodDescriptor.ofMethod((Method)((Method)member));
            this.annotatedElement = (Method)member;
            this.name = ReflectionHelper.isGetterMethod((Method)member) ? ReflectionHelper.getGetterPropertyName(member) : member.getName();
            this.type = ((Method)member).getGenericReturnType();
            this.setter = GizmoMemberDescriptor.lookupSetter(this.memberDescriptor, this.declaringClass, this.name);
        } else {
            throw new IllegalArgumentException(member + " is not a Method or a Field.");
        }
    }

    public GizmoMemberDescriptor(String name, Object memberDescriptor, Class<?> declaringClass, AnnotatedElement annotatedElement, Type type) {
        this(name, memberDescriptor, declaringClass, annotatedElement, type, GizmoMemberDescriptor.lookupSetter(memberDescriptor, declaringClass, name).orElse(null));
    }

    public GizmoMemberDescriptor(String name, Object memberDescriptor, Class<?> declaringClass, AnnotatedElement annotatedElement, Type type, MethodDescriptor setterDescriptor) {
        this.name = name;
        this.memberDescriptor = memberDescriptor;
        this.declaringClass = declaringClass;
        this.annotatedElement = annotatedElement;
        this.type = type;
        this.setter = Optional.ofNullable(setterDescriptor);
    }

    public GizmoMemberDescriptor whenIsField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
        if (this.memberDescriptor instanceof FieldDescriptor) {
            fieldDescriptorConsumer.accept((FieldDescriptor)this.memberDescriptor);
        }
        return this;
    }

    public GizmoMemberDescriptor whenIsMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
        if (this.memberDescriptor instanceof MethodDescriptor) {
            methodDescriptorConsumer.accept((MethodDescriptor)this.memberDescriptor);
        }
        return this;
    }

    public String getDeclaringClassName() {
        if (this.memberDescriptor instanceof FieldDescriptor) {
            return ((FieldDescriptor)this.memberDescriptor).getDeclaringClass();
        }
        if (this.memberDescriptor instanceof MethodDescriptor) {
            return ((MethodDescriptor)this.memberDescriptor).getDeclaringClass();
        }
        throw new IllegalStateException("memberDescriptor not a fieldDescriptor or a methodDescriptor");
    }

    public boolean isInterfaceMethod() {
        if (this.memberDescriptor instanceof MethodDescriptor) {
            return this.declaringClass.isInterface();
        }
        return false;
    }

    public ResultHandle invokeMemberMethod(BytecodeCreator creator, MethodDescriptor method, ResultHandle bean, ResultHandle ... parameters) {
        if (this.isInterfaceMethod()) {
            return creator.invokeInterfaceMethod(method, bean, parameters);
        }
        return creator.invokeVirtualMethod(method, bean, parameters);
    }

    public Optional<MethodDescriptor> getSetter() {
        return this.setter;
    }

    private static Optional<MethodDescriptor> lookupSetter(Object memberDescriptor, Class<?> declaringClass, String name) {
        if (memberDescriptor instanceof MethodDescriptor) {
            return Optional.ofNullable(ReflectionHelper.getSetterMethod(declaringClass, name)).map(MethodDescriptor::ofMethod);
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        boolean isGeneric;
        String typeName = this.type.getTypeName();
        int genericStart = typeName.indexOf(60);
        boolean bl = isGeneric = genericStart != -1;
        if (isGeneric) {
            int genericEnd = typeName.lastIndexOf(62);
            return typeName.substring(0, genericStart) + typeName.substring(genericEnd + 1);
        }
        return typeName;
    }

    public Type getType() {
        return this.type;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    public String toString() {
        return this.memberDescriptor.toString();
    }
}

