/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score;

import java.util.Map;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.DefaultScoreExplanation;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;

public final class DefaultScoreManager<Solution_, Score_ extends Score<Score_>>
implements ScoreManager<Solution_, Score_> {
    private final InnerScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    public DefaultScoreManager(InnerScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public Score_ updateScore(Solution_ solution) {
        try (ScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector();){
            scoreDirector.setWorkingSolution(solution);
            Object Score_ = scoreDirector.calculateScore();
            return Score_;
        }
    }

    @Override
    public String getSummary(Solution_ solution) {
        return this.explainScore(solution).getSummary();
    }

    @Override
    public ScoreExplanation<Solution_, Score_> explainScore(Solution_ solution) {
        try (InnerScoreDirector<Solution_, Score_> scoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(solution);
            boolean constraintMatchEnabled = scoreDirector.isConstraintMatchEnabled();
            if (!constraintMatchEnabled) {
                throw new IllegalStateException("When constraintMatchEnabled (" + constraintMatchEnabled + ") is disabled, this method should not be called.");
            }
            Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap = scoreDirector.getConstraintMatchTotalMap();
            Map<Object, Indictment<Score_>> indictmentMap = scoreDirector.getIndictmentMap();
            DefaultScoreExplanation<Solution_, Score_> defaultScoreExplanation = new DefaultScoreExplanation<Solution_, Score_>(solution, scoreDirector.calculateScore(), constraintMatchTotalMap, indictmentMap);
            return defaultScoreExplanation;
        }
    }
}

