/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.constraint;

import java.util.LinkedHashSet;
import java.util.Set;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.Indictment;

public final class DefaultIndictment<Score_ extends Score<Score_>>
implements Indictment<Score_> {
    private final Object justification;
    private final Set<ConstraintMatch<Score_>> constraintMatchSet;
    private Score_ score;

    public DefaultIndictment(Object justification, Score_ zeroScore) {
        this.justification = justification;
        this.constraintMatchSet = new LinkedHashSet<ConstraintMatch<Score_>>();
        this.score = zeroScore;
    }

    @Override
    public Object getJustification() {
        return this.justification;
    }

    @Override
    public Set<ConstraintMatch<Score_>> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    @Override
    public Score_ getScore() {
        return this.score;
    }

    public void addConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.add(constraintMatch.getScore());
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The indictment (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    public void removeConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The indictment (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultIndictment) {
            DefaultIndictment other = (DefaultIndictment)o;
            return this.justification.equals(other.justification);
        }
        return false;
    }

    public int hashCode() {
        return this.justification.hashCode();
    }

    public String toString() {
        return this.justification + "=" + this.score;
    }
}

