/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.List;
import java.util.function.BiFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBridgeBiNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndexFactory;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;

public final class BavetJoinBridgeBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetJoinBridgeConstraintStream<Solution_> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> parent;
    private BavetJoinConstraintStream<Solution_> joinStream;
    private final boolean isLeftBridge;
    private final BiFunction<A, B, Object[]> mapping;
    private final BavetIndexFactory indexFactory;

    public BavetJoinBridgeBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, boolean isLeftBridge, BiFunction<A, B, Object[]> mapping, BavetIndexFactory indexFactory) {
        super(constraintFactory);
        this.parent = parent;
        this.isLeftBridge = isLeftBridge;
        this.mapping = mapping;
        this.indexFactory = indexFactory;
    }

    public void setJoinStream(BavetJoinConstraintStream<Solution_> joinStream) {
        this.joinStream = joinStream;
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    @Override
    protected BavetJoinBridgeBiNode<A, B> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> parentNode) {
        return new BavetJoinBridgeBiNode<A, B>(buildPolicy.getSession(), buildPolicy.nextNodeIndex(), parentNode, this.mapping, this.indexFactory.buildIndex(this.isLeftBridge));
    }

    @Override
    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> uncastedNode) {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's a join bridge.");
        }
        BavetJoinBridgeBiNode node = (BavetJoinBridgeBiNode)uncastedNode;
        BavetJoinBridgeNode otherBridgeNode = buildPolicy.getJoinConstraintStreamToJoinBridgeNodeMap().get(this.joinStream);
        if (otherBridgeNode == null) {
            buildPolicy.getJoinConstraintStreamToJoinBridgeNodeMap().put(this.joinStream, node);
        } else {
            BavetJoinBridgeNode leftNode = this.isLeftBridge ? node : otherBridgeNode;
            BavetJoinBridgeNode rightNode = this.isLeftBridge ? otherBridgeNode : node;
            this.joinStream.createNodeChain(buildPolicy, constraintWeight, leftNode, rightNode);
        }
    }

    public String toString() {
        return "JoinBridge()";
    }
}

