/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.util.Arrays;
import org.powermock.modules.agent.PowerMockAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockClassRedefiner {
    public static void redefine(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class to redefine cannot be null");
        }
        PowerMockAgent.getClasstransformer().setClassesToTransform(Arrays.asList(cls.getName()));
        try {
            PowerMockAgent.instrumentation().retransformClasses(cls);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine class " + cls.getName(), e);
        }
    }

    public static void redefine(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name to redefine cannot be null");
        }
        try {
            PowerMockClassRedefiner.redefine(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void redefine(String[] classes) {
        PowerMockAgent.getClasstransformer().setClassesToTransform(Arrays.asList(classes));
        for (int i = classes.length - 1; i >= 0; --i) {
            String className = classes[i];
            try {
                Class<?> clazz = Class.forName(className);
                PowerMockAgent.instrumentation().retransformClasses(clazz);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

