/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.powermock.reflect.Whitebox;
import sun.tools.attach.BsdVirtualMachine;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

final class AgentLoader {
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public VirtualMachine attachVirtualMachine(String id) {
            return null;
        }

        @Override
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };
    private final String jarFilePath;
    private final String pid;

    AgentLoader(String jarFilePath) {
        this.jarFilePath = jarFilePath;
        this.pid = AgentLoader.discoverProcessIdForRunningVM();
    }

    private static String discoverProcessIdForRunningVM() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    boolean loadAgent() {
        VirtualMachine vm = AttachProvider.providers().isEmpty() ? this.getVirtualMachineImplementationFromEmbeddedOnes() : this.attachToThisVM();
        if (vm != null) {
            this.loadAgentAndDetachFromThisVM(vm);
            return true;
        }
        return false;
    }

    private VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes() {
        try {
            Class vmClass;
            if (File.separatorChar == '\\') {
                vmClass = WindowsVirtualMachine.class;
            } else {
                String osName = System.getProperty("os.name");
                if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
                    vmClass = LinuxVirtualMachine.class;
                } else if (osName.startsWith("Mac OS X")) {
                    vmClass = BsdVirtualMachine.class;
                } else if (osName.startsWith("Solaris")) {
                    vmClass = SolarisVirtualMachine.class;
                } else {
                    return null;
                }
            }
            Class[] parameterTypes = new Class[]{AttachProvider.class, String.class};
            VirtualMachine newVM = null;
            try {
                newVM = (VirtualMachine)Whitebox.invokeConstructor(vmClass, (Class[])parameterTypes, (Object[])new Object[]{ATTACH_PROVIDER, this.pid});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newVM;
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native library for Attach API not available in this JRE", e);
        }
    }

    private VirtualMachine attachToThisVM() {
        try {
            return VirtualMachine.attach(this.pid);
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadAgentAndDetachFromThisVM(VirtualMachine vm) {
        try {
            vm.loadAgent(this.jarFilePath, null);
            vm.detach();
        }
        catch (AgentLoadException e) {
            throw new RuntimeException(e);
        }
        catch (AgentInitializationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

