/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import sun.tools.attach.HotSpotVirtualMachine;

public class LinuxVirtualMachine
extends HotSpotVirtualMachine {
    private static final String tmpdir = "/tmp";
    static boolean isLinuxThreads;
    String path;
    private static final String PROTOCOL_VERSION = "1";
    private static final int ATTACH_ERROR_BADVERSION = 101;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinuxVirtualMachine(AttachProvider provider, String vmid) throws AttachNotSupportedException, IOException {
        super(provider, vmid);
        int pid;
        try {
            pid = Integer.parseInt(vmid);
        }
        catch (NumberFormatException x) {
            throw new AttachNotSupportedException("Invalid process identifier");
        }
        this.path = this.findSocketFile(pid);
        if (this.path == null) {
            File f = this.createAttachFile(pid);
            try {
                if (isLinuxThreads) {
                    int mpid;
                    try {
                        mpid = LinuxVirtualMachine.getLinuxThreadsManager(pid);
                    }
                    catch (IOException x) {
                        throw new AttachNotSupportedException(x.getMessage());
                    }
                    assert (mpid >= 1);
                    LinuxVirtualMachine.sendQuitToChildrenOf(mpid);
                } else {
                    LinuxVirtualMachine.sendQuitTo(pid);
                }
                int i = 0;
                long delay = 200L;
                int retries = (int)(this.attachTimeout() / delay);
                do {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.path = this.findSocketFile(pid);
                } while (++i <= retries && this.path == null);
                if (this.path == null) {
                    throw new AttachNotSupportedException("Unable to open socket file: target process not responding or HotSpot VM not loaded");
                }
            }
            finally {
                f.delete();
            }
        }
        LinuxVirtualMachine.checkPermissions(this.path);
        int s = LinuxVirtualMachine.socket();
        try {
            LinuxVirtualMachine.connect(s, this.path);
        }
        finally {
            LinuxVirtualMachine.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        LinuxVirtualMachine linuxVirtualMachine = this;
        synchronized (linuxVirtualMachine) {
            if (this.path != null) {
                this.path = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream execute(String cmd, Object ... args) throws AgentLoadException, IOException {
        int completionStatus;
        String p;
        assert (args.length <= 3);
        LinuxVirtualMachine linuxVirtualMachine = this;
        synchronized (linuxVirtualMachine) {
            if (this.path == null) {
                throw new IOException("Detached from target VM");
            }
            p = this.path;
        }
        int s = LinuxVirtualMachine.socket();
        try {
            LinuxVirtualMachine.connect(s, p);
        }
        catch (IOException x) {
            LinuxVirtualMachine.close(s);
            throw x;
        }
        IOException ioe = null;
        try {
            this.writeString(s, PROTOCOL_VERSION);
            this.writeString(s, cmd);
            for (int i = 0; i < 3; ++i) {
                if (i < args.length && args[i] != null) {
                    this.writeString(s, (String)args[i]);
                    continue;
                }
                this.writeString(s, "");
            }
        }
        catch (IOException x) {
            ioe = x;
        }
        SocketInputStream sis = new SocketInputStream(s);
        try {
            completionStatus = this.readInt(sis);
        }
        catch (IOException x) {
            sis.close();
            if (ioe != null) {
                throw ioe;
            }
            throw x;
        }
        if (completionStatus != 0) {
            sis.close();
            if (completionStatus == 101) {
                throw new IOException("Protocol mismatch with target VM");
            }
            if (cmd.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            throw new IOException("Command failed in target VM");
        }
        return sis;
    }

    private String findSocketFile(int pid) {
        File f = new File(tmpdir, ".java_pid" + pid);
        if (!f.exists()) {
            return null;
        }
        return f.getPath();
    }

    private File createAttachFile(int pid) throws IOException {
        String fn = ".attach_pid" + pid;
        String path = "/proc/" + pid + "/cwd/" + fn;
        File f = new File(path);
        try {
            f.createNewFile();
        }
        catch (IOException x) {
            f = new File(tmpdir, fn);
            f.createNewFile();
        }
        return f;
    }

    private void writeString(int fd, String s) throws IOException {
        byte[] b;
        if (s.length() > 0) {
            try {
                b = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException x) {
                throw new InternalError();
            }
            LinuxVirtualMachine.write(fd, b, 0, b.length);
        }
        b = new byte[]{0};
        LinuxVirtualMachine.write(fd, b, 0, 1);
    }

    static native boolean isLinuxThreads();

    static native int getLinuxThreadsManager(int var0) throws IOException;

    static native void sendQuitToChildrenOf(int var0) throws IOException;

    static native void sendQuitTo(int var0) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native int socket() throws IOException;

    static native void connect(int var0, String var1) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void write(int var0, byte[] var1, int var2, int var3) throws IOException;

    static {
        System.loadLibrary("attach");
        isLinuxThreads = LinuxVirtualMachine.isLinuxThreads();
    }

    private class SocketInputStream
    extends InputStream {
        int s;

        public SocketInputStream(int s) {
            this.s = s;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            if (n == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] bs, int off, int len) throws IOException {
            if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            return LinuxVirtualMachine.read(this.s, bs, off, len);
        }

        @Override
        public void close() throws IOException {
            LinuxVirtualMachine.close(this.s);
        }
    }
}

