/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp;

import java.net.InetSocketAddress;
import reactor.core.composable.Promise;
import reactor.core.composable.Stream;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.function.batch.BatchConsumer;

public interface TcpConnection<IN, OUT> {
    public void close();

    public boolean consumable();

    public boolean writable();

    public InetSocketAddress remoteAddress();

    public Stream<IN> in();

    public BatchConsumer<OUT> out();

    public <T extends Throwable> TcpConnection<IN, OUT> when(Class<T> var1, Consumer<T> var2);

    public TcpConnection<IN, OUT> consume(Consumer<IN> var1);

    public TcpConnection<IN, OUT> receive(Function<IN, OUT> var1);

    public TcpConnection<IN, OUT> send(Stream<OUT> var1);

    public Promise<Void> send(OUT var1);

    public TcpConnection<IN, OUT> sendAndForget(OUT var1);

    public Promise<IN> sendAndReceive(OUT var1);

    public ConsumerSpec on();

    public static interface ConsumerSpec<IN, OUT> {
        public ConsumerSpec close(Runnable var1);

        public ConsumerSpec readIdle(long var1, Runnable var3);

        public ConsumerSpec writeIdle(long var1, Runnable var3);
    }
}

