/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Promise;
import reactor.event.Event;
import reactor.event.registry.CachingRegistry;
import reactor.event.registry.Registration;
import reactor.event.registry.Registry;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.tcp.TcpConnection;
import reactor.tcp.config.ServerSocketOptions;
import reactor.tcp.config.SslOptions;
import reactor.tcp.encoding.Codec;
import reactor.tuple.Tuple2;
import reactor.util.Assert;

public abstract class TcpServer<IN, OUT> {
    private final Event<TcpServer<IN, OUT>> selfEvent = Event.wrap((Object)this);
    private final Tuple2<Selector, Object> start = Selectors.$();
    private final Tuple2<Selector, Object> shutdown = Selectors.$();
    private final Tuple2<Selector, Object> open = Selectors.$();
    private final Tuple2<Selector, Object> close = Selectors.$();
    private final Registry<TcpConnection<IN, OUT>> connections = new CachingRegistry();
    private final Reactor reactor;
    private final Codec<Buffer, IN, OUT> codec;
    protected final Environment env;

    protected TcpServer(@Nonnull Environment env, @Nonnull Reactor reactor, @Nullable InetSocketAddress listenAddress, ServerSocketOptions options, SslOptions sslOptions, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Collection<Consumer<TcpConnection<IN, OUT>>> connectionConsumers) {
        Assert.notNull((Object)env, (String)"A TcpServer cannot be created without a properly-configured Environment.");
        Assert.notNull((Object)reactor, (String)"A TcpServer cannot be created without a properly-configured Reactor.");
        this.env = env;
        this.reactor = reactor;
        this.codec = codec;
        Assert.notNull(connectionConsumers, (String)"Connection Consumers cannot be null.");
        for (final Consumer<TcpConnection<IN, OUT>> consumer : connectionConsumers) {
            this.reactor.on((Selector)this.open.getT1(), new Consumer<Event<TcpConnection<IN, OUT>>>(){

                public void accept(Event<TcpConnection<IN, OUT>> ev) {
                    consumer.accept(ev.getData());
                }
            });
        }
    }

    public TcpServer<IN, OUT> start() {
        return this.start(null);
    }

    public abstract TcpServer<IN, OUT> start(@Nullable Consumer<Void> var1);

    public abstract Promise<Void> shutdown();

    protected <C> Registration<? extends TcpConnection<IN, OUT>> register(@Nonnull C channel, @Nonnull TcpConnection<IN, OUT> connection) {
        Assert.notNull(channel, (String)"Channel cannot be null.");
        Assert.notNull(connection, (String)"TcpConnection cannot be null.");
        return this.connections.register(Selectors.$(channel), connection);
    }

    protected <C> TcpConnection<IN, OUT> select(@Nonnull C channel) {
        Assert.notNull(channel, (String)"Channel cannot be null.");
        Iterator conns = this.connections.select(channel).iterator();
        if (conns.hasNext()) {
            return (TcpConnection)((Registration)conns.next()).getObject();
        }
        TcpConnection<IN, OUT> conn = this.createConnection(channel);
        this.register(channel, conn);
        this.notifyOpen(conn);
        return conn;
    }

    protected <C> void close(@Nonnull C channel) {
        Assert.notNull(channel, (String)"Channel cannot be null");
        for (Registration reg : this.connections.select(channel)) {
            TcpConnection conn = (TcpConnection)reg.getObject();
            ((TcpConnection)reg.getObject()).close();
            this.notifyClose(conn);
            reg.cancel();
        }
    }

    protected abstract <C> TcpConnection<IN, OUT> createConnection(C var1);

    protected void notifyError(@Nonnull Throwable error) {
        Assert.notNull((Object)error, (String)"Error cannot be null.");
        this.reactor.notify(error.getClass(), Event.wrap((Object)error));
    }

    protected void notifyStart(final @Nullable Consumer<Void> started) {
        if (null != started) {
            this.reactor.on((Selector)this.start.getT1(), (Consumer)new Consumer<Event<Void>>(){

                public void accept(Event<Void> ev) {
                    started.accept(null);
                }
            });
        }
        this.reactor.notify(this.start.getT2(), this.selfEvent);
    }

    protected void notifyShutdown() {
        this.reactor.notify(this.shutdown.getT2(), this.selfEvent);
    }

    protected void notifyOpen(@Nonnull TcpConnection<IN, OUT> conn) {
        this.reactor.notify(this.open.getT2(), Event.wrap(conn));
    }

    protected void notifyClose(@Nonnull TcpConnection<IN, OUT> conn) {
        this.reactor.notify(this.close.getT2(), Event.wrap(conn));
    }

    @Nullable
    protected Codec<Buffer, IN, OUT> getCodec() {
        return this.codec;
    }

    protected Reactor getReactor() {
        return this.reactor;
    }
}

