/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.encoding;

import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.tcp.encoding.Codec;

public class DelimitedCodec<IN, OUT>
implements Codec<Buffer, IN, OUT> {
    private final Codec<Buffer, IN, OUT> delegate;
    private final byte delimiter;
    private final boolean stripDelimiter;

    public DelimitedCodec(Codec<Buffer, IN, OUT> delegate) {
        this(10, true, delegate);
    }

    public DelimitedCodec(boolean stripDelimiter, Codec<Buffer, IN, OUT> delegate) {
        this(10, stripDelimiter, delegate);
    }

    public DelimitedCodec(byte delimiter, boolean stripDelimiter, Codec<Buffer, IN, OUT> delegate) {
        this.delimiter = delimiter;
        this.stripDelimiter = stripDelimiter;
        this.delegate = delegate;
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        return new DelimitedDecoder(next);
    }

    @Override
    public Function<OUT, Buffer> encoder() {
        return new DelimitedEncoder();
    }

    private class DelimitedEncoder
    implements Function<OUT, Buffer> {
        Function<OUT, Buffer> encoder;

        private DelimitedEncoder() {
            this.encoder = DelimitedCodec.this.delegate.encoder();
        }

        public Buffer apply(OUT out) {
            Buffer buffer = new Buffer();
            Buffer encoded = (Buffer)this.encoder.apply(out);
            if (null != encoded && encoded.remaining() > 0) {
                buffer.append(new Buffer[]{encoded}).append(DelimitedCodec.this.delimiter);
            }
            return buffer.flip();
        }
    }

    private class DelimitedDecoder
    implements Function<Buffer, IN> {
        private final Function<Buffer, IN> decoder;

        DelimitedDecoder(Consumer<IN> next) {
            this.decoder = DelimitedCodec.this.delegate.decoder(next);
        }

        public IN apply(Buffer bytes) {
            if (bytes.remaining() == 0) {
                return null;
            }
            Iterable views = bytes.split((int)DelimitedCodec.this.delimiter, DelimitedCodec.this.stripDelimiter);
            int limit = bytes.limit();
            int position = bytes.position();
            for (Buffer.View view : views) {
                Buffer b = view.get();
                this.decoder.apply((Object)b);
            }
            bytes.limit(limit);
            bytes.position(position);
            return null;
        }
    }
}

