/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.encoding;

import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.tcp.encoding.Codec;
import reactor.util.Assert;

public class LengthFieldCodec<IN, OUT>
implements Codec<Buffer, IN, OUT> {
    private final int lengthFieldLength;
    private final Codec<Buffer, IN, OUT> delegate;

    public LengthFieldCodec(Codec<Buffer, IN, OUT> delegate) {
        this(4, delegate);
    }

    public LengthFieldCodec(int lengthFieldLength, Codec<Buffer, IN, OUT> delegate) {
        Assert.state((lengthFieldLength == 4 || lengthFieldLength == 8 ? 1 : 0) != 0, (String)"lengthFieldLength should either be 4 (int) or 8 (long).");
        this.lengthFieldLength = lengthFieldLength;
        this.delegate = delegate;
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        return new LengthFieldDecoder(next);
    }

    @Override
    public Function<OUT, Buffer> encoder() {
        return new LengthFieldEncoder();
    }

    private class LengthFieldEncoder
    implements Function<OUT, Buffer> {
        private final Function<OUT, Buffer> encoder;

        private LengthFieldEncoder() {
            this.encoder = LengthFieldCodec.this.delegate.encoder();
        }

        public Buffer apply(OUT out) {
            if (null == out) {
                return null;
            }
            Buffer encoded = (Buffer)this.encoder.apply(out);
            if (null != encoded && encoded.remaining() > 0) {
                if (LengthFieldCodec.this.lengthFieldLength == 4) {
                    encoded.prepend(encoded.remaining());
                } else if (LengthFieldCodec.this.lengthFieldLength == 8) {
                    encoded.prepend((long)encoded.remaining());
                }
            }
            return encoded;
        }
    }

    private class LengthFieldDecoder
    implements Function<Buffer, IN> {
        private final Function<Buffer, IN> decoder;

        private LengthFieldDecoder(Consumer<IN> next) {
            this.decoder = LengthFieldCodec.this.delegate.decoder(next);
        }

        public IN apply(Buffer buffer) {
            while (buffer.remaining() > LengthFieldCodec.this.lengthFieldLength) {
                int expectedLen = this.readLen(buffer);
                if (expectedLen > buffer.remaining()) {
                    buffer.rewind(LengthFieldCodec.this.lengthFieldLength);
                    return null;
                }
                int pos = buffer.position();
                int limit = buffer.limit();
                Buffer.View v = buffer.createView(pos, pos + expectedLen);
                Object in = this.decoder.apply((Object)v.get());
                buffer.byteBuffer().limit(limit);
                if (buffer.position() == pos) {
                    buffer.skip(expectedLen);
                }
                if (null == in) continue;
                return in;
            }
            return null;
        }

        private int readLen(Buffer buffer) {
            if (LengthFieldCodec.this.lengthFieldLength == 4) {
                return buffer.readInt();
            }
            return (int)buffer.readLong();
        }
    }
}

