/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.tcp.encoding.Codec;

public class StringCodec
implements Codec<Buffer, String, String> {
    private final Charset utf8 = Charset.forName("UTF-8");

    @Override
    public Function<Buffer, String> decoder(Consumer<String> next) {
        return new StringDecoder(next);
    }

    @Override
    public Function<String, Buffer> encoder() {
        return new StringEncoder();
    }

    private class StringEncoder
    implements Function<String, Buffer> {
        private final CharsetEncoder encoder;

        private StringEncoder() {
            this.encoder = StringCodec.this.utf8.newEncoder();
        }

        public Buffer apply(String s) {
            try {
                ByteBuffer bb = this.encoder.encode(CharBuffer.wrap(s));
                return new Buffer(bb);
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class StringDecoder
    implements Function<Buffer, String> {
        private final Consumer<String> next;
        private final CharsetDecoder decoder;

        private StringDecoder(Consumer<String> next) {
            this.decoder = StringCodec.this.utf8.newDecoder();
            this.next = next;
        }

        public String apply(Buffer bytes) {
            try {
                String s = this.decoder.decode(bytes.byteBuffer()).toString();
                if (null != this.next) {
                    this.next.accept((Object)s);
                    return null;
                }
                return s;
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

