/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.encoding.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.tcp.encoding.Codec;
import reactor.util.Assert;

public class JsonCodec<IN, OUT>
implements Codec<Buffer, IN, OUT> {
    private final Class<IN> inputType;
    private final ObjectMapper mapper;

    public JsonCodec(Class<IN> inputType) {
        this(inputType, null);
    }

    public JsonCodec(Class<IN> inputType, Module customModule) {
        Assert.notNull(inputType, (String)"inputType must not be null");
        this.inputType = null == inputType ? JsonNode.class : inputType;
        this.mapper = new ObjectMapper();
        if (null != customModule) {
            this.mapper.registerModule(customModule);
        }
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        return new JsonDecoder(next);
    }

    @Override
    public Function<OUT, Buffer> encoder() {
        return new JsonEncoder();
    }

    private class JsonEncoder
    implements Function<OUT, Buffer> {
        private JsonEncoder() {
        }

        public Buffer apply(OUT out) {
            try {
                return Buffer.wrap((byte[])JsonCodec.this.mapper.writeValueAsBytes(out));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class JsonDecoder
    implements Function<Buffer, IN> {
        private final Consumer<IN> next;

        private JsonDecoder(Consumer<IN> next) {
            this.next = next;
        }

        public IN apply(Buffer buffer) {
            try {
                Object in = JsonNode.class.isAssignableFrom(JsonCodec.this.inputType) ? JsonCodec.this.mapper.readTree(buffer.inputStream()) : JsonCodec.this.mapper.readValue(buffer.inputStream(), JsonCodec.this.inputType);
                if (null != this.next) {
                    this.next.accept(in);
                    return null;
                }
                return in;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

