/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.encoding.syslog;

import java.util.Calendar;
import java.util.Date;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.tcp.encoding.Codec;
import reactor.tcp.encoding.syslog.SyslogMessage;

public class SyslogCodec
implements Codec<Buffer, SyslogMessage, Void> {
    private static final int MAXIMUM_SEVERITY = 7;
    private static final int MAXIMUM_FACILITY = 23;
    private static final int MINIMUM_PRI = 0;
    private static final int MAXIMUM_PRI = 191;
    private static final int DEFAULT_PRI = 13;
    private static final Function<Void, Buffer> ENDCODER = new Function<Void, Buffer>(){

        public Buffer apply(Void v) {
            return null;
        }
    };

    @Override
    public Function<Buffer, SyslogMessage> decoder(Consumer<SyslogMessage> next) {
        return new SyslogMessageDecoder(next);
    }

    @Override
    public Function<Void, Buffer> encoder() {
        return ENDCODER;
    }

    private class SyslogMessageDecoder
    implements Function<Buffer, SyslogMessage> {
        private final Calendar cal = Calendar.getInstance();
        private final int year = this.cal.get(1);
        private final Consumer<SyslogMessage> next;
        private Buffer.View remainder;

        private SyslogMessageDecoder(Consumer<SyslogMessage> next) {
            this.next = next;
        }

        public SyslogMessage apply(Buffer buffer) {
            return this.parse(buffer);
        }

        private SyslogMessage parse(Buffer buffer) {
            String line = null;
            if (null != this.remainder) {
                line = this.remainder.get().asString();
            }
            int start = 0;
            for (Buffer.View view : buffer.split(10, false)) {
                int end;
                Buffer b = view.get();
                if (b.last() != 10) {
                    this.remainder = view;
                    return null;
                }
                String s = b.asString();
                if ((line = null != line ? line + s : s).isEmpty()) continue;
                int priority = 13;
                int facility = priority / 8;
                int severity = priority % 8;
                int priStart = line.indexOf(60, start);
                int priEnd = line.indexOf(62, start + 1);
                if (priStart == 0) {
                    int pri = Buffer.parseInt((Buffer)b, (int)1, (int)priEnd);
                    if (pri >= 0 && pri <= 191) {
                        priority = pri;
                        facility = priority / 8;
                        severity = priority % 8;
                    }
                    start = 4;
                }
                Date tstamp = this.parseRfc3414Date(b, start, start + 15);
                String host = null;
                if (null != tstamp && null != (host = line.substring(start += 16, end = line.indexOf(32, start)))) {
                    start += host.length() + 1;
                }
                String msg = line.substring(start);
                SyslogMessage syslogMsg = new SyslogMessage(line, priority, facility, severity, tstamp, host, msg);
                if (null == this.next) {
                    return syslogMsg;
                }
                this.next.accept((Object)syslogMsg);
                line = null;
                start = 0;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Date parseRfc3414Date(Buffer b, int start, int end) {
            b.snapshot();
            b.byteBuffer().limit(end);
            b.byteBuffer().position(start);
            int month = -1;
            int day = -1;
            int hr = -1;
            int min = -1;
            int sec = -1;
            block2 : switch (b.read()) {
                case 65: {
                    switch (b.read()) {
                        case 112: {
                            month = 3;
                            b.read();
                            break block2;
                        }
                    }
                    month = 7;
                    b.read();
                    break;
                }
                case 68: {
                    month = 11;
                    b.read();
                    b.read();
                    break;
                }
                case 70: {
                    month = 1;
                    b.read();
                    b.read();
                    break;
                }
                case 74: {
                    switch (b.read()) {
                        case 97: {
                            month = 0;
                            b.read();
                            break block2;
                        }
                    }
                    switch (b.read()) {
                        case 110: {
                            month = 5;
                            break block2;
                        }
                    }
                    month = 6;
                    break;
                }
                case 77: {
                    b.read();
                    switch (b.read()) {
                        case 114: {
                            month = 2;
                            break block2;
                        }
                    }
                    month = 4;
                    break;
                }
                case 78: {
                    month = 10;
                    b.read();
                    b.read();
                    break;
                }
                case 79: {
                    month = 9;
                    b.read();
                    b.read();
                    break;
                }
                case 83: {
                    month = 8;
                    b.read();
                    b.read();
                    break;
                }
                default: {
                    return null;
                }
            }
            while (b.read() == 32) {
            }
            int dayStart = b.position() - 1;
            while (b.read() != 32) {
            }
            int dayEnd = b.position() - 1;
            day = Buffer.parseInt((Buffer)b, (int)dayStart, (int)dayEnd);
            while (b.read() == 32) {
            }
            int timeStart = b.position() - 1;
            hr = Buffer.parseInt((Buffer)b, (int)timeStart, (int)(timeStart + 2));
            min = Buffer.parseInt((Buffer)b, (int)(timeStart + 3), (int)(timeStart + 5));
            sec = Buffer.parseInt((Buffer)b, (int)(timeStart + 6), (int)(timeStart + 8));
            try {
                if (month < 0 || day < 0 || hr < 0 || min < 0 || sec < 0) {
                    Date date = null;
                    return date;
                }
                this.cal.set(this.year, month, day, hr, min, sec);
                Date date = this.cal.getTime();
                return date;
            }
            finally {
                b.reset();
            }
        }
    }
}

