/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.netty;

import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;
import reactor.event.Event;
import reactor.event.dispatch.BaseDispatcher;
import reactor.event.dispatch.BaseLifecycleDispatcher;

public class NettyEventLoopDispatcher
extends BaseLifecycleDispatcher {
    private final EventLoop eventLoop;

    public NettyEventLoopDispatcher(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            return this.eventLoop.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void shutdown() {
        this.eventLoop.shutdownGracefully();
        super.shutdown();
    }

    public void halt() {
        this.eventLoop.shutdownGracefully();
        super.halt();
    }

    protected <E extends Event<?>> BaseDispatcher.Task<E> createTask() {
        return new NettyEventLoopTask();
    }

    private final class NettyEventLoopTask
    extends BaseDispatcher.Task<Event<Object>>
    implements Runnable {
        private NettyEventLoopTask() {
            super((BaseDispatcher)NettyEventLoopDispatcher.this);
        }

        public void submit() {
            NettyEventLoopDispatcher.this.eventLoop.execute((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.execute();
            }
            finally {
                this.reset();
            }
        }
    }
}

