/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.io.Buffer;
import reactor.tcp.netty.NettyTcpConnection;
import reactor.tcp.netty.NettyTcpServer;

class NettyTcpConnectionChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(NettyTcpServer.class);
    private final NettyTcpConnection<?, ?> conn;
    private ByteBuf remainder;

    NettyTcpConnectionChannelInboundHandler(NettyTcpConnection<?, ?> conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            this.conn.notifyRead(msg);
            return;
        }
        ByteBuf data = (ByteBuf)msg;
        if (this.remainder == null) {
            try {
                this.passToConnection(data);
            }
            finally {
                if (data.isReadable()) {
                    this.remainder = data;
                } else {
                    data.release();
                }
            }
            return;
        }
        if (!this.bufferHasSufficientCapacity(this.remainder, data)) {
            ByteBuf combined = this.createCombinedBuffer(this.remainder, data, ctx);
            this.remainder.release();
            this.remainder = combined;
        } else {
            this.remainder.writeBytes(data);
        }
        data.release();
        try {
            this.passToConnection(this.remainder);
        }
        finally {
            if (this.remainder.isReadable()) {
                this.remainder.discardSomeReadBytes();
            } else {
                this.remainder.release();
                this.remainder = null;
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if ("Broken pipe".equals(cause.getMessage()) || "Connection reset by peer".equals(cause.getMessage())) {
            if (this.log.isInfoEnabled()) {
                this.log.info(ctx.channel().toString() + " " + cause.getMessage());
            }
        } else {
            this.conn.notifyError(cause);
        }
        ctx.close();
    }

    private boolean bufferHasSufficientCapacity(ByteBuf receiver, ByteBuf provider) {
        return receiver.writerIndex() <= receiver.maxCapacity() - provider.readableBytes();
    }

    private ByteBuf createCombinedBuffer(ByteBuf partOne, ByteBuf partTwo, ChannelHandlerContext ctx) {
        ByteBuf combined = ctx.alloc().buffer(partOne.readableBytes() + partTwo.readableBytes());
        combined.writeBytes(partOne);
        combined.writeBytes(partTwo);
        return combined;
    }

    private void passToConnection(ByteBuf data) {
        Buffer b = new Buffer(data.nioBuffer());
        int start = b.position();
        this.conn.read(b);
        data.skipBytes(b.position() - start);
    }
}

