/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.spec;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.spec.support.EventRoutingComponentSpec;
import reactor.io.Buffer;
import reactor.tcp.TcpClient;
import reactor.tcp.config.ClientSocketOptions;
import reactor.tcp.config.SslOptions;
import reactor.tcp.encoding.Codec;
import reactor.util.Assert;

public class TcpClientSpec<IN, OUT>
extends EventRoutingComponentSpec<TcpClientSpec<IN, OUT>, TcpClient<IN, OUT>> {
    private final Constructor<TcpClient<IN, OUT>> clientImplConstructor;
    private InetSocketAddress connectAddress;
    private ClientSocketOptions options = new ClientSocketOptions();
    private SslOptions sslOptions = null;
    private Codec<Buffer, IN, OUT> codec;

    public TcpClientSpec(@Nonnull Class<? extends TcpClient> clientImpl) {
        Assert.notNull(clientImpl, (String)"TcpClient implementation class cannot be null.");
        try {
            this.clientImplConstructor = clientImpl.getDeclaredConstructor(Environment.class, Reactor.class, InetSocketAddress.class, ClientSocketOptions.class, SslOptions.class, Codec.class);
            this.clientImplConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpClient class.");
        }
    }

    public TcpClientSpec<IN, OUT> options(ClientSocketOptions options) {
        this.options = options;
        return this;
    }

    public TcpClientSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    public TcpClientSpec<IN, OUT> connect(@Nonnull String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    public TcpClientSpec<IN, OUT> connect(@Nonnull InetSocketAddress connectAddress) {
        Assert.isNull((Object)this.connectAddress, (String)"Connect address is already set.");
        this.connectAddress = connectAddress;
        return this;
    }

    public TcpClientSpec<IN, OUT> codec(@Nullable Codec<Buffer, IN, OUT> codec) {
        Assert.isNull(this.codec, (String)"Codec has already been set.");
        this.codec = codec;
        return this;
    }

    protected TcpClient<IN, OUT> configure(Reactor reactor, Environment env) {
        try {
            return this.clientImplConstructor.newInstance(env, reactor, this.connectAddress, this.options, this.sslOptions, this.codec);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }
}

