/*
 * Decompiled with CFR 0.152.
 */
package reactor.tcp.spec;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.spec.support.EventRoutingComponentSpec;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.tcp.TcpConnection;
import reactor.tcp.TcpServer;
import reactor.tcp.config.ServerSocketOptions;
import reactor.tcp.config.SslOptions;
import reactor.tcp.encoding.Codec;
import reactor.util.Assert;

public class TcpServerSpec<IN, OUT>
extends EventRoutingComponentSpec<TcpServerSpec<IN, OUT>, TcpServer<IN, OUT>> {
    private final Constructor<? extends TcpServer<IN, OUT>> serverImplConstructor;
    private InetSocketAddress listenAddress = new InetSocketAddress("localhost", 3000);
    private ServerSocketOptions options = new ServerSocketOptions();
    private SslOptions sslOptions = null;
    private Codec<Buffer, IN, OUT> codec;
    private Collection<Consumer<TcpConnection<IN, OUT>>> connectionConsumers;

    public TcpServerSpec(@Nonnull Class<? extends TcpServer> serverImpl) {
        Assert.notNull(serverImpl, (String)"TcpServer implementation class cannot be null.");
        try {
            this.serverImplConstructor = serverImpl.getDeclaredConstructor(Environment.class, Reactor.class, InetSocketAddress.class, ServerSocketOptions.class, SslOptions.class, Codec.class, Collection.class);
            this.serverImplConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpServer class.");
        }
    }

    public TcpServerSpec<IN, OUT> options(@Nonnull ServerSocketOptions options) {
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null.");
        this.options = options;
        return this;
    }

    public TcpServerSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    public TcpServerSpec<IN, OUT> listen(int port) {
        this.listenAddress = new InetSocketAddress(port);
        return this;
    }

    public TcpServerSpec<IN, OUT> listen(@Nonnull String host, int port) {
        if (null == host) {
            host = "localhost";
        }
        this.listenAddress = new InetSocketAddress(host, port);
        return this;
    }

    public TcpServerSpec<IN, OUT> codec(@Nonnull Codec<Buffer, IN, OUT> codec) {
        Assert.notNull(codec, (String)"Codec cannot be null.");
        this.codec = codec;
        return this;
    }

    public TcpServerSpec<IN, OUT> consume(@Nonnull Consumer<TcpConnection<IN, OUT>> connectionConsumer) {
        return this.consume(Collections.singletonList(connectionConsumer));
    }

    public TcpServerSpec<IN, OUT> consume(@Nonnull Collection<Consumer<TcpConnection<IN, OUT>>> connectionConsumers) {
        Assert.notNull(connectionConsumers, (String)"Connection consumers cannot be null.");
        this.connectionConsumers = connectionConsumers;
        return this;
    }

    protected TcpServer<IN, OUT> configure(Reactor reactor, Environment env) {
        try {
            return this.serverImplConstructor.newInstance(env, reactor, this.listenAddress, this.options, this.sslOptions, this.codec, this.connectionConsumers);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }
}

