/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import scala.Console$;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.util.SocketServer$;

public abstract class SocketServer
implements ScalaObject {
    private final int port;
    private final ServerSocket serverSocket = this.liftedTree1$1();
    private BufferedReader in;
    private PrintWriter out;

    public static final BufferedOutputStream bufferedOutput(Socket socket) {
        return SocketServer$.MODULE$.bufferedOutput(socket);
    }

    public static final BufferedReader bufferedReader(Socket socket) {
        return SocketServer$.MODULE$.bufferedReader(socket);
    }

    public static final int BufferSize() {
        return SocketServer$.MODULE$.BufferSize();
    }

    public static final int IdleTimeout() {
        return SocketServer$.MODULE$.IdleTimeout();
    }

    public SocketServer() {
        this.port = this.serverSocket().getLocalPort();
    }

    private final Nothing$ fail$1(String s) {
        Object[] objectArray = new Object[1];
        int n = this.port();
        objectArray[0] = BoxesRunTime.boxToInteger((int)n);
        return this.fatal(Predef$.MODULE$.augmentString(s).format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
    }

    private final ServerSocket liftedTree1$1() {
        try {
            ServerSocket exceptionResult2 = new ServerSocket(0);
            return exceptionResult2;
        }
        catch (IOException iOException) {
            throw this.fatal("Could not listen on any port; exiting.");
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        block8: {
            this.serverSocket().setSoTimeout(SocketServer$.MODULE$.IdleTimeout());
            while (!this.shutDown()) {
                Socket exceptionResult1 = this.serverSocket().accept();
                this.doSession(exceptionResult1);
                exceptionResult1.close();
            }
            break block8;
            catch (SocketException socketException) {
                throw this.fail$1("Could not set timeout on port: %d; exiting.");
            }
            {
                catch (IOException iOException) {
                    try {
                        throw this.fail$1("Accept on port %d failed; exiting.");
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        String string = "Timeout elapsed with no requests from clients on port %d; exiting";
                        Object[] objectArray = new Object[1];
                        int n = this.port();
                        objectArray[0] = BoxesRunTime.boxToInteger((int)n);
                        this.warn(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                        this.timeout();
                    }
                }
            }
        }
        this.serverSocket().close();
    }

    public void doSession(Socket clientSocket) {
        this.out_$eq(new PrintWriter(clientSocket.getOutputStream(), true));
        this.in_$eq(SocketServer$.MODULE$.bufferedReader(clientSocket));
        BufferedOutputStream bufout = SocketServer$.MODULE$.bufferedOutput(clientSocket);
        Console$.MODULE$.withOut((OutputStream)bufout, (Function0)new $anonfun$doSession$1(this));
        bufout.close();
        this.out().close();
        this.in().close();
    }

    public int port() {
        return this.port;
    }

    public ServerSocket serverSocket() {
        return this.serverSocket;
    }

    public void timeout() {
    }

    private void warn(String msg) {
        System.err.println(msg);
    }

    public Nothing$ fatal(String msg) {
        System.err.println(msg);
        return Predef$.MODULE$.exit(1);
    }

    public void in_$eq(BufferedReader bufferedReader) {
        this.in = bufferedReader;
    }

    public BufferedReader in() {
        return this.in;
    }

    public void out_$eq(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter out() {
        return this.out;
    }

    public abstract void session();

    public abstract boolean shutDown();
}

