/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.util;

import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.Position$;
import scala.tools.nsc.util.Position$class;
import scala.tools.nsc.util.SourceFile;

public class OffsetPosition
implements Position,
ScalaObject {
    private final int point;
    private final SourceFile source;

    public OffsetPosition(SourceFile source, int point) {
        this.source = source;
        this.point = point;
        Position$class.$init$(this);
    }

    public String show() {
        int n = this.point();
        return new StringBuilder().append((Object)"[").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)"]").toString();
    }

    public String toString() {
        String pointmsg = this.point() > this.source().length() ? "out-of-bounds-" : "offset=";
        String string = "source-%s,line-%s,%s%s";
        Object[] objectArray = new Object[4];
        objectArray[0] = this.source().path();
        int n = this.line();
        objectArray[1] = BoxesRunTime.boxToInteger((int)n);
        objectArray[2] = pointmsg;
        int n2 = this.point();
        objectArray[3] = BoxesRunTime.boxToInteger((int)n2);
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
    }

    public int hashCode() {
        return this.point() * 37 + this.source().file().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof OffsetPosition)) return false;
        OffsetPosition temp7 = (OffsetPosition)that;
        if (this.point() != temp7.point()) return false;
        AbstractFile abstractFile = this.source().file();
        AbstractFile abstractFile2 = temp7.source().file();
        if (abstractFile != null) {
            if (!abstractFile.equals(abstractFile2)) return false;
            return true;
        }
        if (abstractFile2 == null) return true;
        return false;
    }

    public Position union(Position pos) {
        return pos.isRange() ? pos : this;
    }

    public int column() {
        int col = 0;
        for (int idx = this.source().lineToOffset(this.source().offsetToLine(this.point())); idx != this.point(); ++idx) {
            col += this.source().content()[idx] == '\t' ? Position$.MODULE$.tabInc() - col % Position$.MODULE$.tabInc() : 1;
        }
        return col + 1;
    }

    public int line() {
        return this.source().offsetToLine(this.point()) + 1;
    }

    public OffsetPosition withSource(SourceFile source, int shift) {
        return new OffsetPosition(source, this.point() + shift);
    }

    public OffsetPosition withPoint(int off) {
        return new OffsetPosition(this.source(), off);
    }

    public int pointOrElse(int n) {
        return this.point();
    }

    public boolean isDefined() {
        return true;
    }

    public int point() {
        return this.point;
    }

    public SourceFile source() {
        return this.source;
    }

    public String dbgString() {
        return Position$class.dbgString(this);
    }

    public Position inUltimateSource(SourceFile source) {
        return Position$class.inUltimateSource(this, source);
    }

    public String lineContent() {
        return Position$class.lineContent(this);
    }

    public boolean sameRange(Position pos) {
        return Position$class.sameRange(this, pos);
    }

    public boolean overlaps(Position pos) {
        return Position$class.overlaps(this, pos);
    }

    public boolean properlyPrecedes(Position pos) {
        return Position$class.properlyPrecedes(this, pos);
    }

    public boolean precedes(Position pos) {
        return Position$class.precedes(this, pos);
    }

    public boolean properlyIncludes(Position pos) {
        return Position$class.properlyIncludes(this, pos);
    }

    public boolean includes(Position pos) {
        return Position$class.includes(this, pos);
    }

    public Position focusEnd() {
        return Position$class.focusEnd(this);
    }

    public Position focus() {
        return Position$class.focus(this);
    }

    public Position focusStart() {
        return Position$class.focusStart(this);
    }

    public Position withEnd(int off) {
        return Position$class.withEnd(this, off);
    }

    public Position withStart(int off) {
        return Position$class.withStart(this, off);
    }

    public Option offset() {
        return Position$class.offset(this);
    }

    public int endOrPoint() {
        return Position$class.endOrPoint(this);
    }

    public int end() {
        return Position$class.end(this);
    }

    public int startOrPoint() {
        return Position$class.startOrPoint(this);
    }

    public int start() {
        return Position$class.start(this);
    }

    public Position makeTransparent() {
        return Position$class.makeTransparent(this);
    }

    public boolean isOpaqueRange() {
        return Position$class.isOpaqueRange(this);
    }

    public boolean isRange() {
        return Position$class.isRange(this);
    }

    public boolean isTransparent() {
        return Position$class.isTransparent(this);
    }
}

