/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Array$;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.generic.Growable;
import scala.collection.generic.Growable$class;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Builder$class;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedArrayBuilder<A>
implements Builder<A, WrappedArray<A>>,
ScalaObject {
    private int size;
    private int capacity;
    private WrappedArray<A> elems;
    private final ClassManifest<A> manifest;

    public WrappedArrayBuilder(ClassManifest<A> manifest) {
        this.manifest = manifest;
        Growable$class.$init$(this);
        Builder$class.$init$(this);
        this.capacity = 0;
        this.size = 0;
    }

    @Override
    public WrappedArray<A> result() {
        return this.capacity() != 0 && this.capacity() == this.size() ? this.elems() : this.mkArray(this.size());
    }

    @Override
    public void clear() {
        this.size_$eq(0);
    }

    @Override
    public WrappedArrayBuilder<A> $plus$eq(A elem2) {
        this.ensureSize(this.size() + 1);
        this.elems().update(this.size(), elem2);
        this.size_$eq(this.size() + 1);
        return this;
    }

    private void ensureSize(int size2) {
        if (this.capacity() < size2) {
            int newsize;
            int n = newsize = this.capacity() == 0 ? 16 : this.capacity() * 2;
            while (newsize < size2) {
                newsize *= 2;
            }
            this.resize(newsize);
        }
    }

    @Override
    public void sizeHint(int size2) {
        if (this.capacity() < size2) {
            this.resize(size2);
        }
    }

    private void resize(int size2) {
        this.elems_$eq(this.mkArray(size2));
        this.capacity_$eq(size2);
    }

    /*
     * WARNING - void declaration
     */
    private WrappedArray<A> mkArray(int size2) {
        void var2_2;
        WrappedArray<A> newelems = this.manifest.newWrappedArray(size2);
        if (this.size() > 0) {
            Array$.MODULE$.copy(this.elems().array(), 0, newelems.array(), 0, this.size());
        }
        return var2_2;
    }

    private void size_$eq(int n) {
        this.size = n;
    }

    private int size() {
        return this.size;
    }

    private void capacity_$eq(int n) {
        this.capacity = n;
    }

    private int capacity() {
        return this.capacity;
    }

    private void elems_$eq(WrappedArray<A> wrappedArray) {
        this.elems = wrappedArray;
    }

    private WrappedArray<A> elems() {
        return this.elems;
    }

    @Override
    public Growable $plus$plus$eq(Traversable iter) {
        return Growable$class.$plus$plus$eq((Growable)this, iter);
    }

    @Override
    public Growable $plus$plus$eq(Iterator iter) {
        return Growable$class.$plus$plus$eq((Growable)this, iter);
    }

    @Override
    public Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable$class.$plus$eq(this, elem1, elem2, elems);
    }

    @Override
    public Builder mapResult(Function1 f) {
        return Builder$class.mapResult(this, f);
    }
}

