/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.MathContext;
import scala.Array$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$BigDecimal$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericConversions;
import scala.math.ScalaNumericConversions$class;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends ScalaNumber
implements ScalaNumericConversions,
ScalaObject,
Serializable {
    private final MathContext mc;
    private final java.math.BigDecimal bigDecimal;

    public static final BigDecimal double2bigDecimal(double d) {
        return BigDecimal$.MODULE$.double2bigDecimal(d);
    }

    public static final BigDecimal long2bigDecimal(long l) {
        return BigDecimal$.MODULE$.long2bigDecimal(l);
    }

    public static final BigDecimal int2bigDecimal(int n) {
        return BigDecimal$.MODULE$.int2bigDecimal(n);
    }

    public static final BigDecimal valueOf(double d, MathContext mathContext) {
        return BigDecimal$.MODULE$.valueOf(d, mathContext);
    }

    public static final BigDecimal valueOf(double d) {
        return BigDecimal$.MODULE$.valueOf(d);
    }

    public static final MathContext defaultMathContext() {
        return BigDecimal$.MODULE$.defaultMathContext();
    }

    public BigDecimal(java.math.BigDecimal bigDecimal, MathContext mc) {
        this.bigDecimal = bigDecimal;
        this.mc = mc;
        ScalaNumericConversions$class.$init$(this);
    }

    public String toString() {
        return this.bigDecimal().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Option<BigInt> toBigIntExact() {
        void var1_1;
        Option exceptionResult1 = null;
        try {
            exceptionResult1 = new Some<BigInt>(new BigInt(this.bigDecimal().toBigIntegerExact()));
        }
        catch (ArithmeticException arithmeticException) {
            exceptionResult1 = None$.MODULE$;
        }
        return var1_1;
    }

    public BigInt toBigInt() {
        return new BigInt(this.bigDecimal().toBigInteger());
    }

    public NumericRange.Inclusive<BigDecimal> to(BigDecimal end, BigDecimal step) {
        return Range$BigDecimal$.MODULE$.inclusive(this, end, step);
    }

    public Range.Partial<BigDecimal, NumericRange.Inclusive<BigDecimal>> to(BigDecimal end$2) {
        return new Range.Partial<BigDecimal, NumericRange.Inclusive<BigDecimal>>(new $anonfun$to$1(this, end$2));
    }

    public NumericRange.Exclusive<BigDecimal> until(BigDecimal end, BigDecimal step) {
        return Range$BigDecimal$.MODULE$.apply(this, end, step);
    }

    public Range.Partial<BigDecimal, NumericRange.Exclusive<BigDecimal>> until(BigDecimal end$1) {
        return new Range.Partial<BigDecimal, NumericRange.Exclusive<BigDecimal>>(new $anonfun$until$1(this, end$1));
    }

    public long toLongExact() {
        return this.bigDecimal().longValueExact();
    }

    public int toIntExact() {
        return this.bigDecimal().intValueExact();
    }

    public short toShortExact() {
        return this.bigDecimal().shortValueExact();
    }

    public byte toByteExact() {
        return this.bigDecimal().byteValueExact();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimal().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimal().floatValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimal().longValue();
    }

    @Override
    public int intValue() {
        return this.bigDecimal().intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    public BigDecimal setScale(int scale, Enumeration.Value mode) {
        return this.bigdec2BigDecimal(this.bigDecimal().setScale(scale, mode.id()));
    }

    public BigDecimal setScale(int scale) {
        return this.bigdec2BigDecimal(this.bigDecimal().setScale(scale));
    }

    public BigDecimal apply(MathContext mc) {
        return BigDecimal$.MODULE$.apply(this.bigDecimal().toString(), mc);
    }

    public BigDecimal ulp() {
        return this.bigdec2BigDecimal(this.bigDecimal().ulp());
    }

    public int scale() {
        return this.bigDecimal().scale();
    }

    public BigDecimal round(MathContext mc) {
        return this.bigdec2BigDecimal(this.bigDecimal().round(mc));
    }

    public int precision() {
        return this.bigDecimal().precision();
    }

    public int signum() {
        return this.bigDecimal().signum();
    }

    public BigDecimal abs() {
        return this.bigdec2BigDecimal(this.bigDecimal().abs(this.mc()));
    }

    public BigDecimal unary_$minus() {
        return this.bigdec2BigDecimal(this.bigDecimal().negate(this.mc()));
    }

    public BigDecimal pow(int n) {
        return this.bigdec2BigDecimal(this.bigDecimal().pow(n, this.mc()));
    }

    public BigDecimal remainder(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().remainder(that.bigDecimal(), this.mc()));
    }

    public BigDecimal max(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().max(that.bigDecimal()));
    }

    public BigDecimal min(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().min(that.bigDecimal()));
    }

    public BigDecimal quot(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().divideToIntegralValue(that.bigDecimal(), this.mc()));
    }

    public Tuple2<BigDecimal, BigDecimal> $div$percent(BigDecimal that) {
        java.math.BigDecimal[] temp4 = this.bigDecimal().divideAndRemainder(that.bigDecimal(), this.mc());
        Option temp5 = Array$.MODULE$.unapplySeq(temp4);
        if (temp5.isEmpty()) {
            throw new MatchError(temp4.toString());
        }
        IndexedSeq temp6 = (IndexedSeq)temp5.get();
        IndexedSeq indexedSeq = temp6;
        if (indexedSeq == null || indexedSeq.equals(null) ? false : BoxesRunTime.equals(BoxesRunTime.boxToInteger(temp6.lengthCompare(2)), BoxesRunTime.boxToInteger(0))) {
            java.math.BigDecimal temp8;
            java.math.BigDecimal temp7 = (java.math.BigDecimal)temp6.apply(0);
            java.math.BigDecimal r = temp8 = (java.math.BigDecimal)temp6.apply(1);
            java.math.BigDecimal q = temp7;
            if (true) {
                q = temp7;
                r = temp8;
                return new Tuple2<BigDecimal, BigDecimal>(this.bigdec2BigDecimal(q), this.bigdec2BigDecimal(r));
            }
            throw new MatchError(temp4.toString());
        }
        throw new MatchError(temp4.toString());
    }

    public BigDecimal $div(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().divide(that.bigDecimal(), this.mc()));
    }

    public BigDecimal $times(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().multiply(that.bigDecimal(), this.mc()));
    }

    public BigDecimal $minus(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().subtract(that.bigDecimal(), this.mc()));
    }

    public BigDecimal $plus(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().add(that.bigDecimal(), this.mc()));
    }

    public boolean $greater(BigDecimal that) {
        return this.compare(that) > 0;
    }

    public boolean $less(BigDecimal that) {
        return this.compare(that) < 0;
    }

    public boolean $greater$eq(BigDecimal that) {
        return this.compare(that) >= 0;
    }

    public boolean $less$eq(BigDecimal that) {
        return this.compare(that) <= 0;
    }

    public int compare(BigDecimal that) {
        return this.bigDecimal().compareTo(that.bigDecimal());
    }

    public boolean equals(BigDecimal that) {
        return this.compare(that) == 0;
    }

    @Override
    public boolean isWhole() {
        return BoxesRunTime.equals(this.remainder(BigDecimal$.MODULE$.int2bigDecimal(1)), BigDecimal$.MODULE$.apply(0));
    }

    public boolean equals(Object that) {
        Object temp1;
        block7: {
            boolean bl;
            block4: {
                block5: {
                    block6: {
                        BigInt temp3;
                        block2: {
                            block3: {
                                BigDecimal temp2;
                                temp1 = that;
                                if (!(temp1 instanceof BigDecimal)) break block2;
                                BigDecimal that2 = temp2 = (BigDecimal)temp1;
                                if (!true) break block3;
                                that2 = temp2;
                                bl = this.equals(that2);
                                break block4;
                            }
                            throw new MatchError(temp1.toString());
                        }
                        if (!(temp1 instanceof BigInt)) break block5;
                        BigInt that$1 = temp3 = (BigInt)temp1;
                        if (!true) break block6;
                        that$1 = temp3;
                        bl = this.toBigIntExact().exists(new $anonfun$equals$1(this, that$1));
                        break block4;
                    }
                    throw new MatchError(temp1.toString());
                }
                Object x = temp1;
                if (!true) break block7;
                x = temp1;
                bl = this.unifiedPrimitiveEquals(x);
            }
            return bl;
        }
        throw new MatchError(temp1.toString());
    }

    public int hashCode() {
        return this.isWhole() ? this.unifiedPrimitiveHashcode() : ((Object)BoxesRunTime.boxToDouble(this.doubleValue())).hashCode();
    }

    private BigDecimal bigdec2BigDecimal(java.math.BigDecimal x) {
        return new BigDecimal(x, this.mc());
    }

    public BigDecimal(java.math.BigDecimal bigDecimal) {
        this(bigDecimal, BigDecimal$.MODULE$.defaultMathContext());
    }

    public MathContext mc() {
        return this.mc;
    }

    public java.math.BigDecimal bigDecimal() {
        return this.bigDecimal;
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericConversions$class.unifiedPrimitiveEquals(this, x);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericConversions$class.unifiedPrimitiveHashcode(this);
    }

    @Override
    public boolean isValidChar() {
        return ScalaNumericConversions$class.isValidChar(this);
    }

    @Override
    public boolean isValidInt() {
        return ScalaNumericConversions$class.isValidInt(this);
    }

    @Override
    public boolean isValidShort() {
        return ScalaNumericConversions$class.isValidShort(this);
    }

    @Override
    public boolean isValidByte() {
        return ScalaNumericConversions$class.isValidByte(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericConversions$class.toDouble(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericConversions$class.toFloat(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericConversions$class.toLong(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericConversions$class.toInt(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericConversions$class.toShort(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericConversions$class.toByte(this);
    }

    @Override
    public char toChar() {
        return ScalaNumericConversions$class.toChar(this);
    }
}

