/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.lang.reflect.Array;
import scala.CountedIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$Empty$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt;
import scala.runtime.ScalaRunTime$;

public abstract class Iterator$class {
    public static void $init$(Iterator $this) {
    }

    private static final Iterator loop$1(Iterator $this, int left) {
        while (left > 0 && $this.hasNext()) {
            $this.next();
            --left;
        }
        return $this;
    }

    public static void readInto(Iterator $this, Object xs) {
        $this.readInto(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public static void readInto(Iterator $this, Object xs, int start) {
        $this.readInto(xs, start, ScalaRunTime$.MODULE$.array_length(xs) - start);
    }

    public static void readInto(Iterator $this, Object xs, int start, int sz) {
        int i = start;
        while ($this.hasNext() && i - start < sz) {
            Object a = $this.next();
            Array.set(xs, i, a);
            ++i;
        }
    }

    public static CountedIterator counted(Iterator $this) {
        return new Iterator$.anon.1($this);
    }

    public static Seq collect(Iterator $this) {
        return $this.toSeq();
    }

    public static int findIndexOf(Iterator $this, Function1 p) {
        return $this.indexWhere(p);
    }

    public static Iterator append(Iterator $this, Iterator that$4) {
        return $this.$plus$plus(new Iterator$.anonfun.append.1($this, that$4));
    }

    public static String toString(Iterator $this) {
        return new StringBuilder().append((Object)($this.hasNext() ? "non-empty" : "empty")).append((Object)" iterator").toString();
    }

    public static StringBuilder addString(Iterator $this, StringBuilder buf) {
        return $this.addString(buf, "", "", "");
    }

    public static StringBuilder addString(Iterator $this, StringBuilder buf, String sep) {
        return $this.addString(buf, "", sep, "");
    }

    public static StringBuilder addString(Iterator $this, StringBuilder buf, String start, String sep, String end) {
        Object object;
        buf.append(start);
        if ($this.hasNext()) {
            Object a = $this.next();
            object = buf.append(String.valueOf(a));
        } else {
            object = BoxedUnit.UNIT;
        }
        while ($this.hasNext()) {
            buf.append(sep);
            Object a = $this.next();
            buf.append(String.valueOf(a));
        }
        return buf.append(end);
    }

    public static String mkString(Iterator $this) {
        return $this.mkString("");
    }

    public static String mkString(Iterator $this, String sep) {
        return $this.mkString("", sep, "");
    }

    public static String mkString(Iterator $this, String start, String sep, String end) {
        StringBuilder buf = new StringBuilder();
        return $this.addString(buf, start, sep, end).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sameElements(Iterator $this, Iterator that) {
        while ($this.hasNext() && that.hasNext()) {
            void y0;
            void x0;
            Object a = that.next();
            Object a2 = $this.next();
            if (a2 == a ? true : (x0 == null ? false : (x0 instanceof Number || x0 instanceof Character ? BoxesRunTime.equals2(x0, y0) : x0.equals(y0)))) continue;
            return false;
        }
        return !$this.hasNext() && !that.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public static Seq toSeq(Iterator $this) {
        void var1_1;
        ArrayBuffer buffer = new ArrayBuffer();
        $this.copyToBuffer(buffer);
        return var1_1;
    }

    public static Stream toStream(Iterator $this) {
        Stream stream;
        if ($this.hasNext()) {
            Iterator$.anonfun.toStream.1 var2_1 = new Iterator$.anonfun.toStream.1($this);
            Object a = $this.next();
            stream = new Stream.Cons(a, var2_1);
        } else {
            stream = Stream$Empty$.MODULE$;
        }
        return stream;
    }

    public static List toList(Iterator $this) {
        ListBuffer res = new ListBuffer();
        while ($this.hasNext()) {
            res.$plus$eq($this.next());
        }
        return res.toList();
    }

    public static void copyToBuffer(Iterator $this, Buffer dest) {
        while ($this.hasNext()) {
            dest.$plus$eq($this.next());
        }
    }

    public static void copyToArray(Iterator $this, Object xs) {
        $this.copyToArray(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public static void copyToArray(Iterator $this, Object xs, int start) {
        $this.copyToArray(xs, start, ScalaRunTime$.MODULE$.array_length(xs) - start);
    }

    public static void copyToArray(Iterator $this, Object xs, int start, int len) {
        int n = start + len;
        int end = new RichInt(n).min(Array.getLength(xs));
        for (int i = start; $this.hasNext() && i < end; ++i) {
            Object a = $this.next();
            Array.set(xs, i, a);
        }
    }

    public static Iterator patch(Iterator $this, int from$1, Iterator patchElems$1, int replaced$1) {
        return new Iterator$.anon.28($this, from$1, patchElems$1, replaced$1);
    }

    public static Tuple2 duplicate(Iterator $this) {
        Queue gap$1 = new Queue();
        ObjectRef ahead$1 = new ObjectRef(null);
        return new Tuple2<Iterator.Partner.1, Iterator.Partner.1>(new Iterator.Partner.1($this, gap$1, ahead$1), new Iterator.Partner.1($this, gap$1, ahead$1));
    }

    /*
     * WARNING - void declaration
     */
    public static int length(Iterator $this) {
        void var1_1;
        int i = 0;
        while ($this.hasNext()) {
            $this.next();
            ++i;
        }
        return (int)var1_1;
    }

    public static Iterator.GroupedIterator sliding(Iterator $this, int size2, int step) {
        return new Iterator.GroupedIterator($this, $this, size2, step);
    }

    public static Iterator.GroupedIterator grouped(Iterator $this, int size2) {
        return new Iterator.GroupedIterator($this, $this, size2, size2);
    }

    public static BufferedIterator buffered(Iterator $this) {
        return new Iterator$.anon.2($this);
    }

    public static Option reduceRightOption(Iterator $this, Function2 op) {
        return $this.hasNext() ? new Some($this.reduceRight(op)) : None$.MODULE$;
    }

    public static Option reduceLeftOption(Iterator $this, Function2 op) {
        return $this.hasNext() ? new Some($this.reduceLeft(op)) : None$.MODULE$;
    }

    public static Object reduceRight(Iterator $this, Function2 op) {
        if ($this.hasNext()) {
            return $this.foldRight($this.next(), op);
        }
        throw new UnsupportedOperationException("empty.reduceRight");
    }

    public static Object reduceLeft(Iterator $this, Function2 op) {
        if ($this.hasNext()) {
            return $this.foldLeft($this.next(), op);
        }
        throw new UnsupportedOperationException("empty.reduceLeft");
    }

    public static Object $colon$bslash(Iterator $this, Object z, Function2 op) {
        return $this.foldRight(z, op);
    }

    public static Object $div$colon(Iterator $this, Object z, Function2 op) {
        return $this.foldLeft(z, op);
    }

    public static Object foldRight(Iterator $this, Object z, Function2 op) {
        return $this.hasNext() ? op.apply($this.next(), $this.foldRight(z, op)) : z;
    }

    /*
     * WARNING - void declaration
     */
    public static Object foldLeft(Iterator $this, Object z, Function2 op) {
        void var3_3;
        Object acc = z;
        while ($this.hasNext()) {
            acc = op.apply(acc, $this.next());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(Iterator $this, Object elem2) {
        int i = 0;
        boolean found = false;
        while (!found && $this.hasNext()) {
            void x0;
            Object a = $this.next();
            if (a == elem2 ? true : (x0 == null ? false : (x0 instanceof Number || x0 instanceof Character ? BoxesRunTime.equals2(x0, elem2) : x0.equals(elem2)))) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1;
    }

    public static int indexWhere(Iterator $this, Function1 p) {
        int i = 0;
        boolean found = false;
        while (!found && $this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply($this.next()))) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1;
    }

    /*
     * WARNING - void declaration
     */
    public static Option find(Iterator $this, Function1 p) {
        void var2_2;
        Option res = None$.MODULE$;
        while (((Option)res).isEmpty() && $this.hasNext()) {
            Object e = $this.next();
            if (!BoxesRunTime.unboxToBoolean(p.apply(e))) continue;
            res = new Some(e);
        }
        return var2_2;
    }

    public static boolean contains(Iterator $this, Object elem$5) {
        return $this.exists(new Iterator$.anonfun.contains.1($this, elem$5));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = false;
        while (!res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forall(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = true;
        while (res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    public static void foreach(Iterator $this, Function1 f) {
        while ($this.hasNext()) {
            f.apply($this.next());
        }
    }

    public static Iterator zipAll(Iterator $this, Iterator that$1, Object thisElem$1, Object thatElem$1) {
        return new Iterator$.anon.5($this, that$1, thisElem$1, thatElem$1);
    }

    public static Iterator zipWithIndex(Iterator $this) {
        return new Iterator$.anon.27($this);
    }

    public static Iterator padTo(Iterator $this, int len$2, Object elem$4) {
        return new Iterator$.anon.26($this, len$2, elem$4);
    }

    public static Iterator zip(Iterator $this, Iterator that$3) {
        return new Iterator$.anon.6($this, that$3);
    }

    public static Iterator dropWhile(Iterator $this, Function1 p$3) {
        BufferedIterator self$3 = $this.buffered();
        return new Iterator$.anon.25($this, p$3, self$3);
    }

    public static Tuple2 partition(Iterator $this, Function1 p$5) {
        BufferedIterator self$2 = $this.buffered();
        Iterator.PartitionIterator.1 l = new Iterator.PartitionIterator.1($this, p$5, self$2);
        Iterator.PartitionIterator.1 r = new Iterator.PartitionIterator.1($this, (Function1)new Iterator$.anonfun.1($this, p$5), self$2);
        l.other_$eq(r);
        r.other_$eq(l);
        return new Tuple2<Iterator.PartitionIterator.1, Iterator.PartitionIterator.1>(l, r);
    }

    public static Iterator takeWhile(Iterator $this, Function1 p$2) {
        return new Iterator$.anon.24($this, p$2);
    }

    public static Iterator partialMap(Iterator $this, PartialFunction pf$1) {
        BufferedIterator self$1 = $this.buffered();
        return new Iterator$.anon.23($this, pf$1, self$1);
    }

    public static Iterator filterNot(Iterator $this, Function1 p$4) {
        return $this.filter(new Iterator$.anonfun.filterNot.1($this, p$4));
    }

    public static Iterator withFilter(Iterator $this, Function1 p) {
        return $this.filter(p);
    }

    public static Iterator filter(Iterator $this, Function1 p$1) {
        return new Iterator$.anon.22($this, p$1);
    }

    public static Iterator flatMap(Iterator $this, Function1 f$2) {
        return new Iterator$.anon.21($this, f$2);
    }

    public static Iterator $plus$plus(Iterator $this, Function0 that$2) {
        return new Iterator$.anon.20($this, that$2);
    }

    public static Iterator map(Iterator $this, Function1 f$1) {
        return new Iterator$.anon.19($this, f$1);
    }

    public static Iterator slice(Iterator $this, int from2, int until2) {
        return $this.drop(from2).take(until2 - from2);
    }

    public static Iterator drop(Iterator $this, int n) {
        return Iterator$class.loop$1($this, n);
    }

    public static Iterator take(Iterator $this, int n$1) {
        return new Iterator$.anon.18($this, n$1);
    }

    public static /* synthetic */ int sliding$default$2(Iterator $this) {
        return 1;
    }
}

