/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

class FlushScheduler {
    private Operation task;
    private Reactor reactor;
    private Trace trace;
    private Object lock;
    private volatile boolean running;
    private volatile boolean closed;
    private volatile boolean flushing;

    public FlushScheduler(Socket socket, Reactor reactor, Operation task, Object lock) {
        this.trace = socket.getTrace();
        this.reactor = reactor;
        this.task = task;
        this.lock = lock;
    }

    public void repeat() throws IOException {
        if (this.closed) {
            throw new TransportException("Socket closed");
        }
        if (this.running) {
            this.trace.trace((Object)TransportEvent.WRITE_WAIT);
            this.reactor.process(this.task, 4);
        }
    }

    public void schedule(boolean block) throws IOException {
        if (this.closed) {
            throw new TransportException("Socket closed");
        }
        if (!this.running) {
            this.trace.trace((Object)TransportEvent.WRITE_WAIT);
            this.reactor.process(this.task, 4);
            this.running = true;
        }
        if (block) {
            this.listen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws IOException {
        block7: {
            if (this.flushing) {
                throw new TransportException("Socket already flushing");
            }
            try {
                if (this.closed) break block7;
                try {
                    this.flushing = true;
                    this.trace.trace((Object)TransportEvent.WRITE_BLOCKING);
                    this.lock.wait(120000L);
                }
                finally {
                    this.flushing = false;
                }
            }
            catch (Exception e) {
                throw new TransportException("Could not schedule for flush", e);
            }
        }
        if (this.closed) {
            throw new TransportException("Socket closed");
        }
    }

    public void release() {
        this.lock.notifyAll();
    }

    public void ready() {
        this.lock.notifyAll();
        this.running = false;
    }

    public void close() {
        this.lock.notifyAll();
        this.closed = true;
    }
}

