/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.ByteCursor;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Certificate;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportCursor;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportWriter;
import org.simpleframework.transport.trace.Trace;

public class TransportChannel
implements Channel {
    private final Certificate certificate;
    private final Transport transport;
    private final SSLEngine engine;
    private final ByteCursor cursor;
    private final ByteWriter writer;
    private final Trace trace;

    public TransportChannel(Transport transport) throws IOException {
        this.cursor = new TransportCursor(transport);
        this.writer = new TransportWriter(transport);
        this.certificate = transport.getCertificate();
        this.engine = transport.getEngine();
        this.trace = transport.getTrace();
        this.transport = transport;
    }

    public boolean isSecure() {
        return this.engine != null;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public SocketChannel getSocket() {
        return this.transport.getChannel();
    }

    public Map getAttributes() {
        return this.transport.getAttributes();
    }

    public ByteCursor getCursor() {
        return this.cursor;
    }

    public ByteWriter getWriter() {
        return this.writer;
    }

    public void close() {
        try {
            this.transport.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)TransportEvent.ERROR, cause);
        }
    }
}

