/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.ConnectionException;
import org.simpleframework.transport.connect.SocketListenerManager;
import org.simpleframework.transport.trace.TraceAnalyzer;

public class SocketConnection
implements Connection {
    private SocketListenerManager manager;
    private SocketProcessor processor;
    private boolean closed;

    public SocketConnection(SocketProcessor processor) throws IOException {
        this(processor, null);
    }

    public SocketConnection(SocketProcessor processor, TraceAnalyzer analyzer) throws IOException {
        this.manager = new SocketListenerManager(processor, analyzer);
        this.processor = processor;
    }

    public SocketAddress connect(SocketAddress address) throws IOException {
        if (this.closed) {
            throw new ConnectionException("Connection is closed");
        }
        return this.manager.listen(address);
    }

    public SocketAddress connect(SocketAddress address, SSLContext context) throws IOException {
        if (this.closed) {
            throw new ConnectionException("Connection is closed");
        }
        return this.manager.listen(address, context);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.manager.close();
            this.processor.stop();
        }
        this.closed = true;
    }
}

