/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Map;
import org.springframework.amqp.core.AbstractBuilder;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.TopicExchange;

public final class ExchangeBuilder
extends AbstractBuilder {
    private final String name;
    private final String type;
    private boolean durable = true;
    private boolean autoDelete;
    private boolean internal;
    private boolean delayed;
    private boolean ignoreDeclarationExceptions;

    public ExchangeBuilder(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public static ExchangeBuilder directExchange(String name) {
        return new ExchangeBuilder(name, "direct");
    }

    public static ExchangeBuilder topicExchange(String name) {
        return new ExchangeBuilder(name, "topic");
    }

    public static ExchangeBuilder fanoutExchange(String name) {
        return new ExchangeBuilder(name, "fanout");
    }

    public static ExchangeBuilder headersExchange(String name) {
        return new ExchangeBuilder(name, "headers");
    }

    public ExchangeBuilder autoDelete() {
        this.autoDelete = true;
        return this;
    }

    public ExchangeBuilder durable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public ExchangeBuilder withArgument(String key, Object value) {
        this.getOrCreateArguments().put(key, value);
        return this;
    }

    public ExchangeBuilder withArguments(Map<String, Object> arguments) {
        this.getOrCreateArguments().putAll(arguments);
        return this;
    }

    public ExchangeBuilder internal() {
        this.internal = true;
        return this;
    }

    public ExchangeBuilder delayed() {
        this.delayed = true;
        return this;
    }

    public ExchangeBuilder ignoreDeclarationExceptions() {
        this.ignoreDeclarationExceptions = true;
        return this;
    }

    public Exchange build() {
        AbstractExchange exchange = "direct".equals(this.type) ? new DirectExchange(this.name, this.durable, this.autoDelete, this.getArguments()) : ("topic".equals(this.type) ? new TopicExchange(this.name, this.durable, this.autoDelete, this.getArguments()) : ("fanout".equals(this.type) ? new FanoutExchange(this.name, this.durable, this.autoDelete, this.getArguments()) : ("headers".equals(this.type) ? new HeadersExchange(this.name, this.durable, this.autoDelete, this.getArguments()) : new CustomExchange(this.name, this.type, this.durable, this.autoDelete, this.getArguments()))));
        exchange.setInternal(this.internal);
        exchange.setDelayed(this.delayed);
        exchange.setIgnoreDeclarationExceptions(this.ignoreDeclarationExceptions);
        return exchange;
    }
}

