/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.Jackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;

public abstract class AbstractJackson2MessageConverter
extends AbstractMessageConverter
implements BeanClassLoaderAware,
SmartMessageConverter {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_CHARSET = "UTF-8";
    private volatile String defaultCharset = "UTF-8";
    private final MimeType supportedContentType;
    protected final ObjectMapper objectMapper;
    @Nullable
    private ClassMapper classMapper = null;
    protected boolean typeMapperSet;
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private Jackson2JavaTypeMapper javaTypeMapper = new DefaultJackson2JavaTypeMapper();

    protected AbstractJackson2MessageConverter(ObjectMapper objectMapper, MimeType contentType, String ... trustedPackages) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.objectMapper = objectMapper;
        this.supportedContentType = contentType;
        ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setTrustedPackages(trustedPackages);
    }

    @Nullable
    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public void setClassMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public void setDefaultCharset(@Nullable String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (!this.typeMapperSet) {
            ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setBeanClassLoader(classLoader);
        }
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Jackson2JavaTypeMapper getJavaTypeMapper() {
        return this.javaTypeMapper;
    }

    public void setJavaTypeMapper(Jackson2JavaTypeMapper javaTypeMapper) {
        Assert.notNull((Object)javaTypeMapper, (String)"'javaTypeMapper' cannot be null");
        this.javaTypeMapper = javaTypeMapper;
        this.typeMapperSet = true;
    }

    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.javaTypeMapper.getTypePrecedence();
    }

    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        if (this.typeMapperSet) {
            throw new IllegalStateException("When providing your own type mapper, you should set the precedence on it");
        }
        if (!(this.javaTypeMapper instanceof DefaultJackson2JavaTypeMapper)) {
            throw new IllegalStateException("Type precedence is available with the DefaultJackson2JavaTypeMapper");
        }
        ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setTypePrecedence(typePrecedence);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        return this.fromMessage(message, null);
    }

    @Override
    public Object fromMessage(Message message, @Nullable Object conversionHint) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.contains(this.supportedContentType.getSubtype())) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.getDefaultCharset();
                }
                try {
                    if (conversionHint instanceof ParameterizedTypeReference) {
                        content = this.convertBytesToObject(message.getBody(), encoding, this.objectMapper.getTypeFactory().constructType(((ParameterizedTypeReference)conversionHint).getType()));
                    }
                    if (this.getClassMapper() == null) {
                        JavaType targetJavaType = this.getJavaTypeMapper().toJavaType(message.getMessageProperties());
                        content = this.convertBytesToObject(message.getBody(), encoding, targetJavaType);
                    }
                    Class<?> targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                    content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
                }
                catch (IOException e) {
                    throw new MessageConversionException("Failed to convert Message content", e);
                }
            } else if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Could not convert incoming message with content-type [" + contentType + "], '" + this.supportedContentType.getSubtype() + "' keyword missing."));
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object convertBytesToObject(byte[] body, String encoding, JavaType targetJavaType) throws IOException {
        String contentAsString = new String(body, encoding);
        return this.objectMapper.readValue(contentAsString, targetJavaType);
    }

    private Object convertBytesToObject(byte[] body, String encoding, Class<?> targetClass) throws IOException {
        String contentAsString = new String(body, encoding);
        return this.objectMapper.readValue(contentAsString, this.objectMapper.constructType(targetClass));
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) throws MessageConversionException {
        return this.createMessage(objectToConvert, messageProperties, null);
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties, @Nullable Type genericType) throws MessageConversionException {
        byte[] bytes;
        try {
            String jsonString = this.objectMapper.writeValueAsString(objectToConvert);
            bytes = jsonString.getBytes(this.getDefaultCharset());
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        messageProperties.setContentType(this.supportedContentType.toString());
        messageProperties.setContentEncoding(this.getDefaultCharset());
        messageProperties.setContentLength(bytes.length);
        if (this.getClassMapper() == null) {
            this.getJavaTypeMapper().fromJavaType(this.objectMapper.constructType(genericType == null ? objectToConvert.getClass() : genericType), messageProperties);
        } else {
            this.getClassMapper().fromClass(objectToConvert.getClass(), messageProperties);
        }
        return new Message(bytes, messageProperties);
    }
}

