/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;

public class CompositeConnectionListener
implements ConnectionListener {
    private List<ConnectionListener> delegates = new CopyOnWriteArrayList<ConnectionListener>();

    @Override
    public void onCreate(Connection connection) {
        for (ConnectionListener delegate : this.delegates) {
            delegate.onCreate(connection);
        }
    }

    @Override
    public void onClose(Connection connection) {
        for (ConnectionListener delegate : this.delegates) {
            delegate.onClose(connection);
        }
    }

    public void setDelegates(List<? extends ConnectionListener> delegates) {
        this.delegates = new ArrayList<ConnectionListener>(delegates);
    }

    public void addDelegate(ConnectionListener delegate) {
        this.delegates.add(delegate);
    }

    public boolean removeDelegate(ConnectionListener delegate) {
        return this.delegates.remove(delegate);
    }

    public void clearDelegates() {
        this.delegates.clear();
    }
}

