/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.ConsumerChannelRegistry;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.ActiveObjectCounter;
import org.springframework.amqp.rabbit.listener.BlockingQueueConsumer;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.amqp.rabbit.listener.ListenerContainerIdleEvent;
import org.springframework.amqp.rabbit.listener.QueuesNotAvailableException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.ListenerContainerAware;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.ConditionalExceptionLogger;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.support.MetricType;
import org.springframework.retry.interceptor.StatefulRetryOperationsInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.FixedBackOff;

public class SimpleMessageListenerContainer
extends AbstractMessageListenerContainer
implements ApplicationEventPublisherAware {
    private static final long DEFAULT_START_CONSUMER_MIN_INTERVAL = 10000L;
    private static final long DEFAULT_STOP_CONSUMER_MIN_INTERVAL = 60000L;
    private static final int DEFAULT_CONSECUTIVE_ACTIVE_TRIGGER = 10;
    private static final int DEFAULT_CONSECUTIVE_IDLE_TRIGGER = 10;
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    public static final int DEFAULT_PREFETCH_COUNT = 1;
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 5000L;
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    private final AtomicLong lastNoMessageAlert = new AtomicLong();
    private volatile int prefetchCount = 1;
    private volatile long startConsumerMinInterval = 10000L;
    private volatile long stopConsumerMinInterval = 60000L;
    private volatile int consecutiveActiveTrigger = 10;
    private volatile int consecutiveIdleTrigger = 10;
    private volatile int txSize = 1;
    private volatile Executor taskExecutor = new SimpleAsyncTaskExecutor();
    private volatile boolean taskExecutorSet;
    private volatile int concurrentConsumers = 1;
    private volatile Integer maxConcurrentConsumers;
    private volatile boolean exclusive;
    private volatile long lastConsumerStarted;
    private volatile long lastConsumerStopped;
    private long receiveTimeout = 1000L;
    private volatile long shutdownTimeout = 5000L;
    private BackOff recoveryBackOff = new FixedBackOff(5000L, Long.MAX_VALUE);
    private Map<BlockingQueueConsumer, Boolean> consumers;
    private final Object consumersMonitor = new Object();
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute();
    private volatile Advice[] adviceChain = new Advice[0];
    private final ActiveObjectCounter<BlockingQueueConsumer> cancellationLock = new ActiveObjectCounter();
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private volatile boolean defaultRequeueRejected = true;
    private final Map<String, Object> consumerArgs = new HashMap<String, Object>();
    private volatile RabbitAdmin rabbitAdmin;
    private volatile boolean missingQueuesFatal = true;
    private volatile boolean missingQueuesFatalSet;
    private volatile boolean autoDeclare = true;
    private volatile boolean mismatchedQueuesFatal = false;
    private volatile ConsumerTagStrategy consumerTagStrategy;
    private volatile ApplicationEventPublisher applicationEventPublisher;
    private final ContainerDelegate delegate;
    private ContainerDelegate proxy = this.delegate = new ContainerDelegate(){

        @Override
        public void invokeListener(Channel channel, Message message) throws Exception {
            SimpleMessageListenerContainer.super.invokeListener(channel, message);
        }
    };
    private Integer declarationRetries;
    private Long failedDeclarationRetryInterval;
    private Long retryDeclarationInterval;
    private ConditionalExceptionLogger exclusiveConsumerExceptionLogger = new DefaultExclusiveConsumerLogger();
    private Long idleEventInterval;
    private volatile long lastReceive = System.currentTimeMillis();

    public SimpleMessageListenerContainer() {
    }

    public SimpleMessageListenerContainer(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    public void setAdviceChain(Advice[] adviceChain) {
        for (final Advice advice : this.adviceChain = Arrays.copyOf(adviceChain, adviceChain.length)) {
            if (!(advice instanceof StatefulRetryOperationsInterceptor)) continue;
            ReflectionUtils.doWithMethods(StatefulRetryOperationsInterceptor.class, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    try {
                        method.invoke((Object)advice, Boolean.TRUE);
                    }
                    catch (InvocationTargetException e) {
                        SimpleMessageListenerContainer.this.logger.error((Object)"Failed to set useRawKey in retry interceptor", (Throwable)e);
                    }
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return method.getName().equals("setUseRawKey");
                }
            });
        }
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryBackOff = new FixedBackOff(recoveryInterval, Long.MAX_VALUE);
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        Assert.notNull((Object)recoveryBackOff, (String)"'recoveryBackOff' must not be null.");
        this.recoveryBackOff = recoveryBackOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((concurrentConsumers > 0 ? 1 : 0) != 0, (String)"'concurrentConsumers' value must be at least 1 (one)");
        Assert.isTrue((!this.exclusive || concurrentConsumers == 1 ? 1 : 0) != 0, (String)"When the consumer is exclusive, the concurrency must be 1");
        if (this.maxConcurrentConsumers != null) {
            Assert.isTrue((concurrentConsumers <= this.maxConcurrentConsumers ? 1 : 0) != 0, (String)"'concurrentConsumers' cannot be more than 'maxConcurrentConsumers'");
        }
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Changing consumers from " + this.concurrentConsumers + " to " + concurrentConsumers));
            }
            int delta = this.concurrentConsumers - concurrentConsumers;
            this.concurrentConsumers = concurrentConsumers;
            if (this.isActive() && this.consumers != null) {
                if (delta > 0) {
                    Iterator<Map.Entry<BlockingQueueConsumer, Boolean>> entryIterator = this.consumers.entrySet().iterator();
                    while (entryIterator.hasNext() && delta > 0) {
                        Map.Entry<BlockingQueueConsumer, Boolean> entry = entryIterator.next();
                        if (!entry.getValue().booleanValue()) continue;
                        BlockingQueueConsumer consumer = entry.getKey();
                        consumer.basicCancel();
                        this.consumers.put(consumer, false);
                        --delta;
                    }
                } else {
                    this.addAndStartConsumers(-delta);
                }
            }
        }
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        Assert.isTrue((maxConcurrentConsumers >= this.concurrentConsumers ? 1 : 0) != 0, (String)"'maxConcurrentConsumers' value must be at least 'concurrentConsumers'");
        Assert.isTrue((!this.exclusive || maxConcurrentConsumers == 1 ? 1 : 0) != 0, (String)"When the consumer is exclusive, the concurrency must be 1");
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public final void setExclusive(boolean exclusive) {
        Assert.isTrue((!exclusive || this.concurrentConsumers == 1 && (this.maxConcurrentConsumers == null || this.maxConcurrentConsumers == 1) ? 1 : 0) != 0, (String)"When the consumer is exclusive, the concurrency must be 1");
        this.exclusive = exclusive;
    }

    public final void setStartConsumerMinInterval(long startConsumerMinInterval) {
        Assert.isTrue((startConsumerMinInterval > 0L ? 1 : 0) != 0, (String)"'startConsumerMinInterval' must be > 0");
        this.startConsumerMinInterval = startConsumerMinInterval;
    }

    public final void setStopConsumerMinInterval(long stopConsumerMinInterval) {
        Assert.isTrue((stopConsumerMinInterval > 0L ? 1 : 0) != 0, (String)"'stopConsumerMinInterval' must be > 0");
        this.stopConsumerMinInterval = stopConsumerMinInterval;
    }

    public final void setConsecutiveActiveTrigger(int consecutiveActiveTrigger) {
        Assert.isTrue((consecutiveActiveTrigger > 0 ? 1 : 0) != 0, (String)"'consecutiveActiveTrigger' must be > 0");
        this.consecutiveActiveTrigger = consecutiveActiveTrigger;
    }

    public final void setConsecutiveIdleTrigger(int consecutiveIdleTrigger) {
        Assert.isTrue((consecutiveIdleTrigger > 0 ? 1 : 0) != 0, (String)"'consecutiveIdleTrigger' must be > 0");
        this.consecutiveIdleTrigger = consecutiveIdleTrigger;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"taskExecutor must not be null");
        this.taskExecutor = taskExecutor;
        this.taskExecutorSet = true;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setTxSize(int txSize) {
        Assert.isTrue((txSize > 0 ? 1 : 0) != 0, (String)"'txSize' must be > 0");
        this.txSize = txSize;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, (String)"messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    public void setDefaultRequeueRejected(boolean defaultRequeueRejected) {
        this.defaultRequeueRejected = defaultRequeueRejected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumerArguments(Map<String, Object> args) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            this.consumerArgs.clear();
            this.consumerArgs.putAll(args);
        }
    }

    protected RabbitAdmin getRabbitAdmin() {
        return this.rabbitAdmin;
    }

    public void setRabbitAdmin(RabbitAdmin rabbitAdmin) {
        this.rabbitAdmin = rabbitAdmin;
    }

    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
        this.missingQueuesFatalSet = true;
    }

    public void setMismatchedQueuesFatal(boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void setQueueNames(String ... queueName) {
        super.setQueueNames(queueName);
        this.queuesChanged();
    }

    @Override
    public void setQueues(Queue ... queues) {
        super.setQueues(queues);
        this.queuesChanged();
    }

    public void setAutoDeclare(boolean autoDeclare) {
        this.autoDeclare = autoDeclare;
    }

    @Override
    public void addQueueNames(String ... queueName) {
        super.addQueueNames(queueName);
        this.queuesChanged();
    }

    @Override
    public void addQueues(Queue ... queue) {
        super.addQueues(queue);
        this.queuesChanged();
    }

    @Override
    public boolean removeQueueNames(String ... queueName) {
        if (super.removeQueueNames(queueName)) {
            this.queuesChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeQueues(Queue ... queue) {
        if (super.removeQueues(queue)) {
            this.queuesChanged();
            return true;
        }
        return false;
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    public void setExclusiveConsumerExceptionLogger(ConditionalExceptionLogger exclusiveConsumerExceptionLogger) {
        this.exclusiveConsumerExceptionLogger = exclusiveConsumerExceptionLogger;
    }

    public void setIdleEventInterval(long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        Assert.state((!this.getAcknowledgeMode().isAutoAck() || this.transactionManager == null ? 1 : 0) != 0, (String)"The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having an external transaction manager. Either use a different AcknowledgeMode or make sure the transactionManager is null.");
    }

    private void initializeProxy() {
        if (this.adviceChain.length == 0) {
            return;
        }
        ProxyFactory factory = new ProxyFactory();
        for (Advice advice : this.getAdviceChain()) {
            factory.addAdvisor((Advisor)new DefaultPointcutAdvisor(Pointcut.TRUE, advice));
        }
        factory.setProxyTargetClass(false);
        factory.addInterface(ContainerDelegate.class);
        factory.setTarget((Object)this.delegate);
        this.proxy = (ContainerDelegate)factory.getProxy(ContainerDelegate.class.getClassLoader());
    }

    protected final boolean sharedConnectionEnabled() {
        return true;
    }

    @Override
    protected void doInitialize() throws Exception {
        this.checkMissingQueuesFatal();
        if (!this.isExposeListenerChannel() && this.transactionManager != null) {
            this.logger.warn((Object)"exposeListenerChannel=false is ignored when using a TransactionManager");
        }
        if (!this.taskExecutorSet && StringUtils.hasText((String)this.getBeanName())) {
            this.taskExecutor = new SimpleAsyncTaskExecutor(this.getBeanName() + "-");
            this.taskExecutorSet = true;
        }
        this.initializeProxy();
        if (this.transactionManager != null && !this.isChannelTransacted()) {
            this.logger.debug((Object)"The 'channelTransacted' is coerced to 'true', when 'transactionManager' is provided");
            this.setChannelTransacted(true);
        }
    }

    @ManagedMetric(metricType=MetricType.GAUGE)
    public int getActiveConsumerCount() {
        return this.cancellationLock.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        Collection<String> expectedQueueNames;
        if (this.getMessageListener() instanceof ListenerContainerAware && (expectedQueueNames = ((ListenerContainerAware)this.getMessageListener()).expectedQueueNames()) != null) {
            String[] queueNames = this.getQueueNames();
            Assert.state((expectedQueueNames.size() == queueNames.length ? 1 : 0) != 0, (String)("Listener expects us to be listening on '" + expectedQueueNames + "'; our queues: " + Arrays.asList(queueNames)));
            boolean found = false;
            for (String queueName : queueNames) {
                if (!expectedQueueNames.contains(queueName)) {
                    found = false;
                    break;
                }
                found = true;
            }
            Assert.state((boolean)found, (String)("Listener expects us to be listening on '" + expectedQueueNames + "'; our queues: " + Arrays.asList(queueNames)));
        }
        if (this.rabbitAdmin == null && this.getApplicationContext() != null) {
            Map admins = this.getApplicationContext().getBeansOfType(RabbitAdmin.class);
            if (admins.size() == 1) {
                this.rabbitAdmin = (RabbitAdmin)admins.values().iterator().next();
            } else {
                if ((this.autoDeclare || this.mismatchedQueuesFatal) && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("For 'autoDeclare' and 'mismatchedQueuesFatal' to work, there must be exactly one RabbitAdmin in the context or you must inject one into this container; found: " + admins.size() + " for container " + this.toString()));
                }
                if (this.mismatchedQueuesFatal) {
                    throw new IllegalStateException("When 'mismatchedQueuesFatal' is 'true', there must be exactly one RabbitAdmin in the context or you must inject one into this container; found: " + admins.size() + " for container " + this.toString());
                }
            }
        }
        this.checkMismatchedQueues();
        super.doStart();
        Object object = this.consumersMonitor;
        synchronized (object) {
            int newConsumers = this.initializeConsumers();
            if (this.consumers == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Consumers were initialized and then cleared (presumably the container was stopped concurrently)");
                }
                return;
            }
            if (newConsumers <= 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Consumers are already running");
                }
                return;
            }
            HashSet<AsyncMessageProcessingConsumer> processors = new HashSet<AsyncMessageProcessingConsumer>();
            for (BlockingQueueConsumer consumer : this.consumers.keySet()) {
                AsyncMessageProcessingConsumer processor = new AsyncMessageProcessingConsumer(consumer);
                processors.add(processor);
                this.taskExecutor.execute(processor);
            }
            for (AsyncMessageProcessingConsumer processor : processors) {
                FatalListenerStartupException startupException = processor.getStartupException();
                if (startupException == null) continue;
                throw new AmqpIllegalStateException("Fatal exception on listener startup", (Throwable)((Object)startupException));
            }
        }
    }

    @Override
    protected void doStop() {
        this.shutdown();
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown() {
        if (!this.isRunning()) {
            return;
        }
        try {
            Object object = this.consumersMonitor;
            synchronized (object) {
                if (this.consumers != null) {
                    for (BlockingQueueConsumer consumer : this.consumers.keySet()) {
                        consumer.basicCancel();
                    }
                }
            }
            this.logger.info((Object)"Waiting for workers to finish.");
            boolean finished = this.cancellationLock.await(this.shutdownTimeout, TimeUnit.MILLISECONDS);
            if (finished) {
                this.logger.info((Object)"Successfully waited for workers to finish.");
            } else {
                this.logger.info((Object)"Workers not finished.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn((Object)"Interrupted waiting for workers.  Continuing with shutdown.");
        }
        Object object = this.consumersMonitor;
        synchronized (object) {
            this.consumers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActive(BlockingQueueConsumer consumer) {
        Boolean consumerActive;
        Object object = this.consumersMonitor;
        synchronized (object) {
            Boolean active;
            consumerActive = this.consumers != null ? Boolean.valueOf((active = this.consumers.get(consumer)) != null && active != false) : Boolean.valueOf(false);
        }
        return consumerActive != false && this.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initializeConsumers() {
        int count = 0;
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers == null) {
                this.cancellationLock.reset();
                this.consumers = new HashMap<BlockingQueueConsumer, Boolean>(this.concurrentConsumers);
                for (int i = 0; i < this.concurrentConsumers; ++i) {
                    BlockingQueueConsumer consumer = this.createBlockingQueueConsumer();
                    this.consumers.put(consumer, true);
                    ++count;
                }
            }
        }
        return count;
    }

    private void checkMissingQueuesFatal() {
        block4: {
            if (!this.missingQueuesFatalSet) {
                try {
                    Properties properties;
                    String missingQueuesFatal;
                    ApplicationContext applicationContext = this.getApplicationContext();
                    if (applicationContext != null && StringUtils.hasText((String)(missingQueuesFatal = (properties = (Properties)applicationContext.getBean("spring.amqp.global.properties", Properties.class)).getProperty("smlc.missing.queues.fatal")))) {
                        this.missingQueuesFatal = Boolean.parseBoolean(missingQueuesFatal);
                    }
                }
                catch (BeansException be) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)"No global properties bean");
                }
            }
        }
    }

    private void checkMismatchedQueues() {
        if (this.mismatchedQueuesFatal && this.rabbitAdmin != null) {
            try {
                this.rabbitAdmin.initialize();
            }
            catch (AmqpConnectException e) {
                this.logger.info((Object)"Broker not available; cannot check queue declarations");
            }
            catch (AmqpIOException e) {
                if (RabbitUtils.isMismatchedQueueArgs((Exception)((Object)e))) {
                    throw new FatalListenerStartupException("Mismatched queues", e);
                }
                this.logger.info((Object)("Failed to get connection during start(): " + (Object)((Object)e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAndStartConsumers(int delta) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                for (int i = 0; i < delta; ++i) {
                    BlockingQueueConsumer consumer = this.createBlockingQueueConsumer();
                    this.consumers.put(consumer, true);
                    AsyncMessageProcessingConsumer processor = new AsyncMessageProcessingConsumer(consumer);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting a new consumer: " + consumer));
                    }
                    this.taskExecutor.execute(processor);
                    try {
                        FatalListenerStartupException startupException = processor.getStartupException();
                        if (startupException != null) {
                            this.consumers.remove(consumer);
                            throw new AmqpIllegalStateException("Fatal exception on listener startup", (Throwable)((Object)startupException));
                        }
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (Exception e) {
                        consumer.stop();
                        this.logger.error((Object)"Error starting new consumer", (Throwable)e);
                        this.cancellationLock.release(consumer);
                        this.consumers.remove(consumer);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerAddingAConsumer() {
        Object object = this.consumersMonitor;
        synchronized (object) {
            long now;
            if (this.consumers != null && this.maxConcurrentConsumers != null && this.consumers.size() < this.maxConcurrentConsumers && this.lastConsumerStarted + this.startConsumerMinInterval < (now = System.currentTimeMillis())) {
                this.addAndStartConsumers(1);
                this.lastConsumerStarted = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerStoppingAConsumer(BlockingQueueConsumer consumer) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            long now;
            if (this.consumers != null && this.consumers.size() > this.concurrentConsumers && this.lastConsumerStopped + this.stopConsumerMinInterval < (now = System.currentTimeMillis())) {
                consumer.basicCancel();
                this.consumers.put(consumer, false);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Idle consumer terminating: " + consumer));
                }
                this.lastConsumerStopped = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuesChanged() {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                int count = 0;
                for (Map.Entry<BlockingQueueConsumer, Boolean> consumer : this.consumers.entrySet()) {
                    if (!consumer.getValue().booleanValue()) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Queues changed; stopping consumer: " + consumer.getKey()));
                    }
                    consumer.getKey().basicCancel();
                    consumer.setValue(false);
                    ++count;
                }
                this.addAndStartConsumers(count);
            }
        }
    }

    @Override
    protected boolean isChannelLocallyTransacted(Channel channel) {
        return super.isChannelLocallyTransacted(channel) && this.transactionManager == null;
    }

    protected BlockingQueueConsumer createBlockingQueueConsumer() {
        String[] queues = this.getRequiredQueueNames();
        int actualPrefetchCount = this.prefetchCount > this.txSize ? this.prefetchCount : this.txSize;
        BlockingQueueConsumer consumer = new BlockingQueueConsumer(this.getConnectionFactory(), this.messagePropertiesConverter, this.cancellationLock, this.getAcknowledgeMode(), this.isChannelTransacted(), actualPrefetchCount, this.defaultRequeueRejected, this.consumerArgs, this.exclusive, queues);
        if (this.declarationRetries != null) {
            consumer.setDeclarationRetries(this.declarationRetries);
        }
        if (this.failedDeclarationRetryInterval != null) {
            consumer.setFailedDeclarationRetryInterval(this.failedDeclarationRetryInterval);
        }
        if (this.retryDeclarationInterval != null) {
            consumer.setRetryDeclarationInterval(this.retryDeclarationInterval);
        }
        if (this.consumerTagStrategy != null) {
            consumer.setTagStrategy(this.consumerTagStrategy);
        }
        consumer.setBackOffExecution(this.recoveryBackOff.start());
        consumer.setShutdownTimeout(this.shutdownTimeout);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart(BlockingQueueConsumer consumer) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                try {
                    consumer.stop();
                    this.cancellationLock.release(consumer);
                    this.consumers.remove(consumer);
                    BlockingQueueConsumer newConsumer = this.createBlockingQueueConsumer();
                    newConsumer.setBackOffExecution(consumer.getBackOffExecution());
                    consumer = newConsumer;
                    this.consumers.put(consumer, true);
                }
                catch (RuntimeException e) {
                    this.logger.warn((Object)("Consumer failed irretrievably on restart. " + e.getClass() + ": " + e.getMessage()));
                    throw e;
                }
                this.taskExecutor.execute(new AsyncMessageProcessingConsumer(consumer));
            }
        }
    }

    private synchronized void redeclareElementsIfNecessary() {
        if (this.rabbitAdmin == null) {
            return;
        }
        try {
            ApplicationContext applicationContext = this.getApplicationContext();
            if (applicationContext != null) {
                Set<String> queueNames = this.getQueueNamesAsSet();
                Map queueBeans = applicationContext.getBeansOfType(Queue.class);
                for (Map.Entry entry : queueBeans.entrySet()) {
                    Queue queue = (Queue)entry.getValue();
                    if (!this.mismatchedQueuesFatal && (!queueNames.contains(queue.getName()) || this.rabbitAdmin.getQueueProperties(queue.getName()) != null)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Redeclaring context exchanges, queues, bindings.");
                    }
                    this.rabbitAdmin.initialize();
                    return;
                }
            }
        }
        catch (Exception e) {
            if (RabbitUtils.isMismatchedQueueArgs(e)) {
                throw new FatalListenerStartupException("Mismatched queues", e);
            }
            this.logger.error((Object)"Failed to check/redeclare auto-delete queue(s).", (Throwable)e);
        }
    }

    private boolean receiveAndExecute(final BlockingQueueConsumer consumer) throws Throwable {
        if (this.transactionManager != null) {
            try {
                return (Boolean)new TransactionTemplate(this.transactionManager, (TransactionDefinition)this.transactionAttribute).execute((TransactionCallback)new TransactionCallback<Boolean>(){

                    public Boolean doInTransaction(TransactionStatus status) {
                        ConnectionFactoryUtils.bindResourceToTransaction(new RabbitResourceHolder(consumer.getChannel(), false), SimpleMessageListenerContainer.this.getConnectionFactory(), true);
                        try {
                            return SimpleMessageListenerContainer.this.doReceiveAndExecute(consumer);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new WrappedTransactionException(e);
                        }
                    }
                });
            }
            catch (WrappedTransactionException e) {
                throw e.getCause();
            }
        }
        return this.doReceiveAndExecute(consumer);
    }

    private boolean doReceiveAndExecute(BlockingQueueConsumer consumer) throws Throwable {
        Channel channel = consumer.getChannel();
        for (int i = 0; i < this.txSize; ++i) {
            this.logger.trace((Object)"Waiting for message from consumer.");
            Message message = consumer.nextMessage(this.receiveTimeout);
            if (message == null) break;
            try {
                this.executeListener(channel, message);
                continue;
            }
            catch (ImmediateAcknowledgeAmqpException e) {
                break;
            }
            catch (Throwable ex) {
                consumer.rollbackOnExceptionIfNecessary(ex);
                throw ex;
            }
        }
        return consumer.commitIfNecessary(this.isChannelLocallyTransacted(channel));
    }

    private Advice[] getAdviceChain() {
        return this.adviceChain;
    }

    @Override
    protected void invokeListener(Channel channel, Message message) throws Exception {
        this.proxy.invokeListener(channel, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStartupFailure(BackOffExecution backOffExecution) throws Exception {
        long recoveryInterval = backOffExecution.nextBackOff();
        if (-1L == recoveryInterval) {
            SimpleMessageListenerContainer simpleMessageListenerContainer = this;
            synchronized (simpleMessageListenerContainer) {
                if (this.isActive()) {
                    this.logger.warn((Object)"stopping container - restart recovery attempts exhausted");
                    this.stop();
                }
            }
            return;
        }
        try {
            if (this.logger.isDebugEnabled() && this.isActive()) {
                this.logger.debug((Object)("Recovering consumer in " + recoveryInterval + " ms."));
            }
            long timeout = System.currentTimeMillis() + recoveryInterval;
            while (this.isActive() && System.currentTimeMillis() < timeout) {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unrecoverable interruption on consumer restart");
        }
    }

    public String toString() {
        return "SimpleMessageListenerContainer " + (this.getBeanName() != null ? "(" + this.getBeanName() + ") " : "") + "[concurrentConsumers=" + this.concurrentConsumers + (this.maxConcurrentConsumers != null ? ", maxConcurrentConsumers=" + this.maxConcurrentConsumers : "") + ", queueNames=" + Arrays.toString(this.getQueueNames()) + "]";
    }

    private static class DefaultExclusiveConsumerLogger
    implements ConditionalExceptionLogger {
        private DefaultExclusiveConsumerLogger() {
        }

        public void log(Log logger, String message, Throwable t) {
            if (t instanceof ShutdownSignalException) {
                ShutdownSignalException cause = (ShutdownSignalException)t;
                if (RabbitUtils.isExclusiveUseChannelClose(cause)) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(message + ": " + cause.toString()));
                    }
                } else if (!RabbitUtils.isNormalChannelClose(cause)) {
                    logger.error((Object)(message + ": " + cause.getMessage()));
                }
            } else {
                logger.error((Object)("Unexpected invocation of " + this.getClass() + ", with message: " + message), t);
            }
        }
    }

    private static final class WrappedTransactionException
    extends RuntimeException {
        private WrappedTransactionException(Throwable cause) {
            super(cause);
        }
    }

    private final class AsyncMessageProcessingConsumer
    implements Runnable {
        private final BlockingQueueConsumer consumer;
        private final CountDownLatch start;
        private volatile FatalListenerStartupException startupException;

        private AsyncMessageProcessingConsumer(BlockingQueueConsumer consumer) {
            this.consumer = consumer;
            this.start = new CountDownLatch(1);
        }

        private FatalListenerStartupException getStartupException() throws TimeoutException, InterruptedException {
            this.start.await(60000L, TimeUnit.MILLISECONDS);
            return this.startupException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean aborted = false;
            int consecutiveIdles = 0;
            int consecutiveMessages = 0;
            try {
                try {
                    if (SimpleMessageListenerContainer.this.autoDeclare) {
                        SimpleMessageListenerContainer.this.redeclareElementsIfNecessary();
                    }
                    this.consumer.start();
                    this.start.countDown();
                }
                catch (QueuesNotAvailableException e) {
                    if (SimpleMessageListenerContainer.this.missingQueuesFatal) {
                        throw e;
                    }
                    this.start.countDown();
                    SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                    throw e;
                }
                catch (FatalListenerStartupException ex) {
                    throw ex;
                }
                catch (Throwable t) {
                    this.start.countDown();
                    SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                    throw t;
                }
                if (SimpleMessageListenerContainer.this.transactionManager != null) {
                    ConsumerChannelRegistry.registerConsumerChannel(this.consumer.getChannel(), SimpleMessageListenerContainer.this.getConnectionFactory());
                }
                while (SimpleMessageListenerContainer.this.isActive(this.consumer) || this.consumer.hasDelivery() || !this.consumer.cancelled()) {
                    try {
                        boolean receivedOk = SimpleMessageListenerContainer.this.receiveAndExecute(this.consumer);
                        if (SimpleMessageListenerContainer.this.maxConcurrentConsumers != null) {
                            if (receivedOk) {
                                if (SimpleMessageListenerContainer.this.isActive(this.consumer)) {
                                    consecutiveIdles = 0;
                                    if (consecutiveMessages++ > SimpleMessageListenerContainer.this.consecutiveActiveTrigger) {
                                        SimpleMessageListenerContainer.this.considerAddingAConsumer();
                                        consecutiveMessages = 0;
                                    }
                                }
                            } else {
                                consecutiveMessages = 0;
                                if (consecutiveIdles++ > SimpleMessageListenerContainer.this.consecutiveIdleTrigger) {
                                    SimpleMessageListenerContainer.this.considerStoppingAConsumer(this.consumer);
                                    consecutiveIdles = 0;
                                }
                            }
                        }
                        if (SimpleMessageListenerContainer.this.idleEventInterval == null) continue;
                        if (receivedOk) {
                            SimpleMessageListenerContainer.this.lastReceive = System.currentTimeMillis();
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        long lastAlertAt = SimpleMessageListenerContainer.this.lastNoMessageAlert.get();
                        long lastReceive = SimpleMessageListenerContainer.this.lastReceive;
                        if (now <= lastReceive + SimpleMessageListenerContainer.this.idleEventInterval || now <= lastAlertAt + SimpleMessageListenerContainer.this.idleEventInterval || !SimpleMessageListenerContainer.this.lastNoMessageAlert.compareAndSet(lastAlertAt, now)) continue;
                        this.publishIdleContainerEvent(now - lastReceive);
                    }
                    catch (ListenerExecutionFailedException ex) {
                        if (!(ex.getCause() instanceof NoSuchMethodException)) continue;
                        throw new FatalListenerExecutionException("Invalid listener", (Throwable)((Object)ex));
                    }
                    catch (AmqpRejectAndDontRequeueException ex) {
                    }
                }
            }
            catch (InterruptedException e) {
                SimpleMessageListenerContainer.this.logger.debug((Object)"Consumer thread interrupted, processing stopped.");
                Thread.currentThread().interrupt();
                aborted = true;
                this.publishConsumerFailedEvent("Consumer thread interrupted, processing stopped", true, e);
            }
            catch (QueuesNotAvailableException ex) {
                if (SimpleMessageListenerContainer.this.missingQueuesFatal) {
                    SimpleMessageListenerContainer.this.logger.error((Object)"Consumer received fatal exception on startup", (Throwable)((Object)ex));
                    this.startupException = ex;
                    aborted = true;
                }
                this.publishConsumerFailedEvent("Consumer queue(s) not available", aborted, (Throwable)((Object)ex));
            }
            catch (FatalListenerStartupException ex) {
                SimpleMessageListenerContainer.this.logger.error((Object)"Consumer received fatal exception on startup", (Throwable)((Object)ex));
                this.startupException = ex;
                aborted = true;
                this.publishConsumerFailedEvent("Consumer received fatal exception on startup", true, (Throwable)((Object)ex));
            }
            catch (FatalListenerExecutionException ex) {
                SimpleMessageListenerContainer.this.logger.error((Object)"Consumer received fatal exception during processing", (Throwable)((Object)ex));
                aborted = true;
                this.publishConsumerFailedEvent("Consumer received fatal exception during processing", true, (Throwable)((Object)ex));
            }
            catch (ShutdownSignalException e) {
                if (RabbitUtils.isNormalShutdown(e)) {
                    if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                        SimpleMessageListenerContainer.this.logger.debug((Object)("Consumer received Shutdown Signal, processing stopped: " + e.getMessage()));
                    }
                } else {
                    this.logConsumerException(e);
                }
            }
            catch (AmqpIOException e) {
                if (e.getCause() instanceof IOException && e.getCause().getCause() instanceof ShutdownSignalException && e.getCause().getCause().getMessage().contains("in exclusive use")) {
                    SimpleMessageListenerContainer.this.exclusiveConsumerExceptionLogger.log(SimpleMessageListenerContainer.this.logger, "Exclusive consumer failure", e.getCause().getCause());
                    this.publishConsumerFailedEvent("Consumer raised exception, attempting restart", false, e);
                } else {
                    this.logConsumerException(e);
                }
            }
            catch (Error e) {
                SimpleMessageListenerContainer.this.logger.error((Object)"Consumer thread error, thread abort.", (Throwable)e);
                aborted = true;
            }
            catch (Throwable t) {
                if (SimpleMessageListenerContainer.this.isActive()) {
                    this.logConsumerException(t);
                }
            }
            finally {
                if (SimpleMessageListenerContainer.this.transactionManager != null) {
                    ConsumerChannelRegistry.unRegisterConsumerChannel();
                }
            }
            this.start.countDown();
            if (!SimpleMessageListenerContainer.this.isActive(this.consumer) || aborted) {
                SimpleMessageListenerContainer.this.logger.debug((Object)("Cancelling " + this.consumer));
                try {
                    this.consumer.stop();
                    SimpleMessageListenerContainer.this.cancellationLock.release(this.consumer);
                    Object t = SimpleMessageListenerContainer.this.consumersMonitor;
                    synchronized (t) {
                        if (SimpleMessageListenerContainer.this.consumers != null) {
                            SimpleMessageListenerContainer.this.consumers.remove(this.consumer);
                        }
                    }
                }
                catch (AmqpException e) {
                    SimpleMessageListenerContainer.this.logger.info((Object)"Could not cancel message consumer", (Throwable)e);
                }
                if (aborted) {
                    SimpleMessageListenerContainer.this.logger.error((Object)"Stopping container from aborted consumer");
                    SimpleMessageListenerContainer.this.stop();
                }
            } else {
                SimpleMessageListenerContainer.this.logger.info((Object)("Restarting " + this.consumer));
                SimpleMessageListenerContainer.this.restart(this.consumer);
            }
        }

        private void logConsumerException(Throwable t) {
            if (SimpleMessageListenerContainer.this.logger.isDebugEnabled() || !(t instanceof AmqpConnectException) && !(t instanceof ConsumerCancelledException)) {
                SimpleMessageListenerContainer.this.logger.warn((Object)"Consumer raised exception, processing can restart if the connection factory supports it", t);
            } else {
                SimpleMessageListenerContainer.this.logger.warn((Object)("Consumer raised exception, processing can restart if the connection factory supports it. Exception summary: " + t));
            }
            this.publishConsumerFailedEvent("Consumer raised exception, attempting restart", false, t);
        }

        private void publishConsumerFailedEvent(String reason, boolean fatal, Throwable t) {
            if (SimpleMessageListenerContainer.this.applicationEventPublisher != null) {
                SimpleMessageListenerContainer.this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerContainerConsumerFailedEvent(SimpleMessageListenerContainer.this, reason, t, fatal));
            }
        }

        private void publishIdleContainerEvent(long idleTime) {
            if (SimpleMessageListenerContainer.this.applicationEventPublisher != null) {
                SimpleMessageListenerContainer.this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerContainerIdleEvent(SimpleMessageListenerContainer.this, idleTime, SimpleMessageListenerContainer.this.getListenerId(), SimpleMessageListenerContainer.this.getQueueNames()));
            }
        }
    }

    public static interface ContainerDelegate {
        public void invokeListener(Channel var1, Message var2) throws Exception;
    }
}

