/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class InterfaceBasedMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler {
    private Class[] managedInterfaces;
    private Map interfaceMappings;

    public void setManagedInterfaces(Class[] managedInterfaces) {
        if (managedInterfaces != null) {
            for (int x = 0; x < managedInterfaces.length; ++x) {
                if (managedInterfaces[x].isInterface()) continue;
                throw new IllegalArgumentException("Management interface [" + managedInterfaces[x].getName() + "] is not an interface");
            }
        }
        this.managedInterfaces = managedInterfaces;
    }

    public void setInterfaceMappings(Properties mappings) {
        this.interfaceMappings = new HashMap(mappings.size());
        Enumeration<Object> en = mappings.keys();
        while (en.hasMoreElements()) {
            String beanKey = (String)en.nextElement();
            String[] classNames = StringUtils.commaDelimitedListToStringArray((String)mappings.getProperty(beanKey));
            Class[] classes = this.convertToClasses(classNames, beanKey);
            this.interfaceMappings.put(beanKey, classes);
        }
    }

    private Class[] convertToClasses(String[] classNames, String beanKey) {
        Class[] classes = new Class[classNames.length];
        for (int x = 0; x < classes.length; ++x) {
            try {
                Class cls = ClassUtils.forName((String)classNames[x].trim());
                if (!cls.isInterface()) {
                    throw new IllegalArgumentException("Class [" + classNames[x] + "] mapped to bean key [" + beanKey + "] is not an interface");
                }
                classes[x] = cls;
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Class [" + classNames[x] + "] mapped to bean key [" + beanKey + "] cannot be found: " + ex.getMessage());
            }
        }
        return classes;
    }

    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    protected boolean includeOperation(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    private boolean isPublicInInterface(Method method, String beanKey) {
        return this.isPublic(method) && this.isDeclaredInInterface(method, beanKey);
    }

    private boolean isPublic(Method method) {
        return (method.getModifiers() & 1) > 0;
    }

    private boolean isDeclaredInInterface(Method method, String beanKey) {
        Class[] ifaces = null;
        if (this.interfaceMappings != null) {
            ifaces = (Class[])this.interfaceMappings.get(beanKey);
        }
        if (ifaces == null && (ifaces = this.managedInterfaces) == null) {
            ifaces = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        }
        if (ifaces != null) {
            for (int i = 0; i < ifaces.length; ++i) {
                Method[] methods = ifaces[i].getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    Method ifaceMethod = methods[j];
                    if (!ifaceMethod.getName().equals(method.getName()) || !Arrays.equals(ifaceMethod.getParameterTypes(), method.getParameterTypes())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

