/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.web.reactive.function.client.ExchangeStrategies;

final class DefaultExchangeStrategiesBuilder
implements ExchangeStrategies.Builder {
    private final ClientCodecConfigurer codecConfigurer = ClientCodecConfigurer.create();

    public DefaultExchangeStrategiesBuilder() {
        this.codecConfigurer.registerDefaults(false);
    }

    public void defaultConfiguration() {
        this.codecConfigurer.registerDefaults(true);
    }

    @Override
    public ExchangeStrategies.Builder codecs(Consumer<ClientCodecConfigurer> consumer) {
        consumer.accept(this.codecConfigurer);
        return this;
    }

    @Override
    public ExchangeStrategies build() {
        return new DefaultExchangeStrategies(this.codecConfigurer.getReaders(), this.codecConfigurer.getWriters());
    }

    private static class DefaultExchangeStrategies
    implements ExchangeStrategies {
        private final List<HttpMessageReader<?>> messageReaders;
        private final List<HttpMessageWriter<?>> messageWriters;

        public DefaultExchangeStrategies(List<HttpMessageReader<?>> messageReaders, List<HttpMessageWriter<?>> messageWriters) {
            this.messageReaders = DefaultExchangeStrategies.unmodifiableCopy(messageReaders);
            this.messageWriters = DefaultExchangeStrategies.unmodifiableCopy(messageWriters);
        }

        private static <T> List<T> unmodifiableCopy(List<? extends T> list) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }

        @Override
        public List<HttpMessageReader<?>> messageReaders() {
            return this.messageReaders;
        }

        @Override
        public List<HttpMessageWriter<?>> messageWriters() {
            return this.messageWriters;
        }
    }
}

