/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;

public abstract class ExchangeFunctions {
    private static final Log logger = LogFactory.getLog(ExchangeFunctions.class);

    public static ExchangeFunction create(ClientHttpConnector connector) {
        return ExchangeFunctions.create(connector, ExchangeStrategies.withDefaults());
    }

    public static ExchangeFunction create(ClientHttpConnector connector, ExchangeStrategies strategies) {
        Assert.notNull((Object)connector, (String)"ClientHttpConnector must not be null");
        Assert.notNull((Object)strategies, (String)"ExchangeStrategies must not be null");
        return new DefaultExchangeFunction(connector, strategies);
    }

    private static class DefaultExchangeFunction
    implements ExchangeFunction {
        private final ClientHttpConnector connector;
        private final ExchangeStrategies strategies;

        public DefaultExchangeFunction(ClientHttpConnector connector, ExchangeStrategies strategies) {
            this.connector = connector;
            this.strategies = strategies;
        }

        @Override
        public Mono<ClientResponse> exchange(ClientRequest request) {
            Assert.notNull((Object)request, (String)"ClientRequest must not be null");
            return this.connector.connect(request.method(), request.url(), clientHttpRequest -> request.writeTo((ClientHttpRequest)clientHttpRequest, this.strategies)).doOnSubscribe(subscription -> logger.debug((Object)"Subscriber present")).doOnRequest(n -> logger.debug((Object)"Demand signaled")).doOnCancel(() -> logger.debug((Object)"Cancelling request")).map(response -> {
                if (logger.isDebugEnabled()) {
                    int status = response.getRawStatusCode();
                    HttpStatus resolvedStatus = HttpStatus.resolve((int)status);
                    logger.debug((Object)("Response received, status: " + status + (resolvedStatus != null ? " " + resolvedStatus.getReasonPhrase() : "")));
                }
                return new DefaultClientResponse((ClientHttpResponse)response, this.strategies);
            });
        }
    }
}

