/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.TomcatWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.DefaultServerEndpointConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TomcatRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private static final String SERVER_CONTAINER_ATTR = "javax.websocket.server.ServerContainer";
    @Nullable
    private Long asyncSendTimeout;
    @Nullable
    private Long maxSessionIdleTimeout;
    @Nullable
    private Integer maxTextMessageBufferSize;
    @Nullable
    private Integer maxBinaryMessageBufferSize;
    @Nullable
    private WsServerContainer serverContainer;

    public void setAsyncSendTimeout(Long timeoutInMillis) {
        this.asyncSendTimeout = timeoutInMillis;
    }

    @Nullable
    public Long getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    public void setMaxSessionIdleTimeout(Long timeoutInMillis) {
        this.maxSessionIdleTimeout = timeoutInMillis;
    }

    @Nullable
    public Long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxTextMessageBufferSize(Integer bufferSize) {
        this.maxTextMessageBufferSize = bufferSize;
    }

    @Nullable
    public Integer getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(Integer bufferSize) {
        this.maxBinaryMessageBufferSize = bufferSize;
    }

    @Nullable
    public Integer getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        StandardWebSocketHandlerAdapter endpoint = new StandardWebSocketHandlerAdapter(handler, session -> {
            HandshakeInfo info = this.getHandshakeInfo(exchange, subProtocol);
            DataBufferFactory factory = response.bufferFactory();
            return new TomcatWebSocketSession((Session)session, info, factory);
        });
        String requestURI = servletRequest.getRequestURI();
        DefaultServerEndpointConfig config = new DefaultServerEndpointConfig(requestURI, endpoint);
        config.setSubprotocols(subProtocol != null ? Collections.singletonList(subProtocol) : Collections.emptyList());
        try {
            WsServerContainer container = this.getContainer(servletRequest);
            container.doUpgrade(servletRequest, servletResponse, (ServerEndpointConfig)config, Collections.emptyMap());
        }
        catch (IOException | ServletException ex) {
            return Mono.error((Throwable)ex);
        }
        return Mono.empty();
    }

    private HttpServletRequest getHttpServletRequest(ServerHttpRequest request) {
        Assert.isInstanceOf(AbstractServerHttpRequest.class, (Object)request, (String)"ServletServerHttpRequest required");
        return (HttpServletRequest)((AbstractServerHttpRequest)request).getNativeRequest();
    }

    private HttpServletResponse getHttpServletResponse(ServerHttpResponse response) {
        Assert.isInstanceOf(AbstractServerHttpResponse.class, (Object)response, (String)"ServletServerHttpResponse required");
        return (HttpServletResponse)((AbstractServerHttpResponse)response).getNativeResponse();
    }

    private HandshakeInfo getHandshakeInfo(ServerWebExchange exchange, @Nullable String protocol) {
        ServerHttpRequest request = exchange.getRequest();
        Mono principal = exchange.getPrincipal();
        return new HandshakeInfo(request.getURI(), request.getHeaders(), (Mono<Principal>)principal, protocol);
    }

    private WsServerContainer getContainer(HttpServletRequest request) {
        if (this.serverContainer == null) {
            Object container = request.getServletContext().getAttribute(SERVER_CONTAINER_ATTR);
            Assert.state((boolean)(container instanceof WsServerContainer), (String)"ServletContext attribute 'javax.websocket.server.ServerContainer' not found.");
            this.serverContainer = (WsServerContainer)container;
            this.initServerContainer((ServerContainer)this.serverContainer);
        }
        return this.serverContainer;
    }

    private void initServerContainer(ServerContainer serverContainer) {
        if (this.asyncSendTimeout != null) {
            serverContainer.setAsyncSendTimeout(this.asyncSendTimeout.longValue());
        }
        if (this.maxSessionIdleTimeout != null) {
            serverContainer.setDefaultMaxSessionIdleTimeout(this.maxSessionIdleTimeout.longValue());
        }
        if (this.maxTextMessageBufferSize != null) {
            serverContainer.setDefaultMaxTextMessageBufferSize(this.maxTextMessageBufferSize.intValue());
        }
        if (this.maxBinaryMessageBufferSize != null) {
            serverContainer.setDefaultMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize.intValue());
        }
    }
}

