/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultWebClientBuilder;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface WebClient {
    public RequestHeadersUriSpec<?> get();

    public RequestHeadersUriSpec<?> head();

    public RequestBodyUriSpec post();

    public RequestBodyUriSpec put();

    public RequestBodyUriSpec patch();

    public RequestHeadersUriSpec<?> delete();

    public RequestHeadersUriSpec<?> options();

    public RequestBodyUriSpec method(HttpMethod var1);

    public Builder mutate();

    public static WebClient create() {
        return new DefaultWebClientBuilder().build();
    }

    public static WebClient create(String baseUrl) {
        return new DefaultWebClientBuilder().baseUrl(baseUrl).build();
    }

    public static Builder builder() {
        return new DefaultWebClientBuilder();
    }

    public static interface RequestBodyUriSpec
    extends RequestBodySpec,
    RequestHeadersUriSpec<RequestBodySpec> {
    }

    public static interface RequestHeadersUriSpec<S extends RequestHeadersSpec<S>>
    extends UriSpec<S>,
    RequestHeadersSpec<S> {
    }

    public static interface ResponseSpec {
        public ResponseSpec onStatus(Predicate<HttpStatus> var1, Function<ClientResponse, Mono<? extends Throwable>> var2);

        public ResponseSpec onRawStatus(IntPredicate var1, Function<ClientResponse, Mono<? extends Throwable>> var2);

        public <T> Mono<T> bodyToMono(Class<T> var1);

        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> var1);

        public <T> Flux<T> bodyToFlux(Class<T> var1);

        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> var1);

        public <T> Mono<ResponseEntity<T>> toEntity(Class<T> var1);

        public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> var1);

        public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> var1);

        public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> var1);

        public Mono<ResponseEntity<Void>> toBodilessEntity();
    }

    public static interface RequestBodySpec
    extends RequestHeadersSpec<RequestBodySpec> {
        public RequestBodySpec contentLength(long var1);

        public RequestBodySpec contentType(MediaType var1);

        public RequestHeadersSpec<?> bodyValue(Object var1);

        public <T, P extends Publisher<T>> RequestHeadersSpec<?> body(P var1, Class<T> var2);

        public <T, P extends Publisher<T>> RequestHeadersSpec<?> body(P var1, ParameterizedTypeReference<T> var2);

        public RequestHeadersSpec<?> body(Object var1, Class<?> var2);

        public RequestHeadersSpec<?> body(Object var1, ParameterizedTypeReference<?> var2);

        public RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> var1);

        @Deprecated
        public RequestHeadersSpec<?> syncBody(Object var1);
    }

    public static interface RequestHeadersSpec<S extends RequestHeadersSpec<S>> {
        public S accept(MediaType ... var1);

        public S acceptCharset(Charset ... var1);

        public S cookie(String var1, String var2);

        public S cookies(Consumer<MultiValueMap<String, String>> var1);

        public S ifModifiedSince(ZonedDateTime var1);

        public S ifNoneMatch(String ... var1);

        public S header(String var1, String ... var2);

        public S headers(Consumer<HttpHeaders> var1);

        public S attribute(String var1, Object var2);

        public S attributes(Consumer<Map<String, Object>> var1);

        public ResponseSpec retrieve();

        public Mono<ClientResponse> exchange();
    }

    public static interface UriSpec<S extends RequestHeadersSpec<?>> {
        public S uri(URI var1);

        public S uri(String var1, Object ... var2);

        public S uri(String var1, Map<String, ?> var2);

        public S uri(String var1, Function<UriBuilder, URI> var2);

        public S uri(Function<UriBuilder, URI> var1);
    }

    public static interface Builder {
        public Builder baseUrl(String var1);

        public Builder defaultUriVariables(Map<String, ?> var1);

        public Builder uriBuilderFactory(UriBuilderFactory var1);

        public Builder defaultHeader(String var1, String ... var2);

        public Builder defaultHeaders(Consumer<HttpHeaders> var1);

        public Builder defaultCookie(String var1, String ... var2);

        public Builder defaultCookies(Consumer<MultiValueMap<String, String>> var1);

        public Builder defaultRequest(Consumer<RequestHeadersSpec<?>> var1);

        public Builder filter(ExchangeFilterFunction var1);

        public Builder filters(Consumer<List<ExchangeFilterFunction>> var1);

        public Builder clientConnector(ClientHttpConnector var1);

        public Builder codecs(Consumer<ClientCodecConfigurer> var1);

        public Builder exchangeStrategies(ExchangeStrategies var1);

        @Deprecated
        public Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> var1);

        public Builder exchangeFunction(ExchangeFunction var1);

        public Builder apply(Consumer<Builder> var1);

        public Builder clone();

        public WebClient build();
    }
}

