/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import javax.portlet.ActionRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.context.PortletWebRequest;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;
import org.springframework.web.portlet.mvc.AbstractController;

public abstract class BaseCommandController
extends AbstractController {
    private static final String RENDER_COMMAND_SESSION_ATTRIBUTE = "org.springframework.web.portlet.mvc.RenderCommand";
    private static final String RENDER_ERRORS_SESSION_ATTRIBUTE = "org.springframework.web.portlet.mvc.RenderErrors";
    public static final String DEFAULT_COMMAND_NAME = "command";
    private String commandName = "command";
    private Class commandClass;
    private Validator[] validators;
    private boolean validateOnBinding = true;
    private MessageCodesResolver messageCodesResolver;
    private BindingErrorProcessor bindingErrorProcessor;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private WebBindingInitializer webBindingInitializer;

    public final void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public final String getCommandName() {
        return this.commandName;
    }

    public final void setCommandClass(Class commandClass) {
        this.commandClass = commandClass;
    }

    public final Class getCommandClass() {
        return this.commandClass;
    }

    public final void setValidator(Validator validator) {
        this.validators = new Validator[]{validator};
    }

    public final Validator getValidator() {
        return this.validators != null && this.validators.length > 0 ? this.validators[0] : null;
    }

    public final void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    public final void setValidateOnBinding(boolean validateOnBinding) {
        this.validateOnBinding = validateOnBinding;
    }

    public final boolean isValidateOnBinding() {
        return this.validateOnBinding;
    }

    public final void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public final MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public final void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public final BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public final void setPropertyEditorRegistrar(PropertyEditorRegistrar propertyEditorRegistrar) {
        this.propertyEditorRegistrars = new PropertyEditorRegistrar[]{propertyEditorRegistrar};
    }

    public final void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public final PropertyEditorRegistrar[] getPropertyEditorRegistrars() {
        return this.propertyEditorRegistrars;
    }

    public final void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public final WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    protected void initApplicationContext() {
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (this.commandClass == null || this.validators[i].supports(this.commandClass)) continue;
                throw new IllegalArgumentException("Validator [" + this.validators[i] + "] does not support command class [" + this.commandClass.getName() + "]");
            }
        }
    }

    protected Object getCommand(PortletRequest request) throws Exception {
        return this.createCommand();
    }

    protected final Object createCommand() throws Exception {
        if (this.commandClass == null) {
            throw new IllegalStateException("Cannot create command without commandClass being set - either set commandClass or (in a form controller) override formBackingObject");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new command of class [" + this.commandClass.getName() + "]"));
        }
        return BeanUtils.instantiateClass((Class)this.commandClass);
    }

    protected final boolean checkCommand(Object command) {
        return this.commandClass == null || this.commandClass.isInstance(command);
    }

    protected final PortletRequestDataBinder bindAndValidate(PortletRequest request, Object command) throws Exception {
        PortletRequestDataBinder binder = this.createBinder(request, command);
        if (!this.suppressBinding(request)) {
            binder.bind(request);
            BindException errors = new BindException(binder.getBindingResult());
            this.onBind(request, command, errors);
            if (this.validators != null && this.isValidateOnBinding() && !this.suppressValidation(request)) {
                for (int i = 0; i < this.validators.length; ++i) {
                    ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)command, (Errors)errors);
                }
            }
            this.onBindAndValidate(request, command, errors);
        }
        return binder;
    }

    protected boolean suppressBinding(PortletRequest request) {
        return false;
    }

    protected PortletRequestDataBinder createBinder(PortletRequest request, Object command) throws Exception {
        PortletRequestDataBinder binder = new PortletRequestDataBinder(command, this.getCommandName());
        this.prepareBinder(binder);
        this.initBinder(request, binder);
        return binder;
    }

    protected final void prepareBinder(PortletRequestDataBinder binder) {
        if (this.useDirectFieldAccess()) {
            binder.initDirectFieldAccess();
        }
        if (this.messageCodesResolver != null) {
            binder.setMessageCodesResolver(this.messageCodesResolver);
        }
        if (this.bindingErrorProcessor != null) {
            binder.setBindingErrorProcessor(this.bindingErrorProcessor);
        }
        if (this.propertyEditorRegistrars != null) {
            for (int i = 0; i < this.propertyEditorRegistrars.length; ++i) {
                this.propertyEditorRegistrars[i].registerCustomEditors((PropertyEditorRegistry)binder);
            }
        }
    }

    protected boolean useDirectFieldAccess() {
        return false;
    }

    protected void initBinder(PortletRequest request, PortletRequestDataBinder binder) throws Exception {
        if (this.webBindingInitializer != null) {
            this.webBindingInitializer.initBinder((WebDataBinder)binder, (WebRequest)new PortletWebRequest(request));
        }
    }

    protected void onBind(PortletRequest request, Object command, BindException errors) throws Exception {
        this.onBind(request, command);
    }

    protected void onBind(PortletRequest request, Object command) throws Exception {
    }

    protected boolean suppressValidation(PortletRequest request) {
        return false;
    }

    protected void onBindAndValidate(PortletRequest request, Object command, BindException errors) throws Exception {
    }

    protected String getRenderCommandSessionAttributeName() {
        return RENDER_COMMAND_SESSION_ATTRIBUTE;
    }

    protected String getRenderErrorsSessionAttributeName() {
        return RENDER_ERRORS_SESSION_ATTRIBUTE;
    }

    protected final Object getRenderCommand(RenderRequest request) throws PortletException {
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            throw new PortletSessionRequiredException("Could not obtain portlet session");
        }
        Object command = session.getAttribute(this.getRenderCommandSessionAttributeName());
        if (command == null) {
            throw new PortletSessionRequiredException("Could not obtain command object from portlet session");
        }
        return command;
    }

    protected final BindException getRenderErrors(RenderRequest request) throws PortletException {
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            throw new PortletSessionRequiredException("Could not obtain portlet session");
        }
        BindException errors = (BindException)session.getAttribute(this.getRenderErrorsSessionAttributeName());
        if (errors == null) {
            throw new PortletSessionRequiredException("Could not obtain errors object from portlet session");
        }
        return errors;
    }

    protected final void setRenderCommandAndErrors(ActionRequest request, Object command, BindException errors) throws Exception {
        this.logger.debug((Object)"Storing command and error objects in session for render phase");
        PortletSession session = request.getPortletSession();
        session.setAttribute(this.getRenderCommandSessionAttributeName(), command);
        session.setAttribute(this.getRenderErrorsSessionAttributeName(), (Object)errors);
    }
}

