/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.sockjs.SockJsMessageDeliveryException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.SockJsSession;

public abstract class AbstractSockJsSession
implements SockJsSession {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String id;
    private final SockJsServiceConfig config;
    private final WebSocketHandler handler;
    private final Map<String, Object> handshakeAttributes;
    private State state = State.NEW;
    private final long timeCreated;
    private long timeLastActive = this.timeCreated = System.currentTimeMillis();
    private ScheduledFuture<?> heartbeatTask;

    public AbstractSockJsSession(String id, SockJsServiceConfig config, WebSocketHandler handler, Map<String, Object> handshakeAttributes) {
        Assert.notNull((Object)id, (String)"SessionId must not be null");
        Assert.notNull((Object)config, (String)"SockJsConfig must not be null");
        Assert.notNull((Object)handler, (String)"WebSocketHandler must not be null");
        this.id = id;
        this.config = config;
        this.handler = handler;
        this.handshakeAttributes = handshakeAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public SockJsServiceConfig getSockJsServiceConfig() {
        return this.config;
    }

    @Override
    public Map<String, Object> getHandshakeAttributes() {
        return this.handshakeAttributes;
    }

    public boolean isNew() {
        return State.NEW.equals((Object)this.state);
    }

    @Override
    public boolean isOpen() {
        return State.OPEN.equals((Object)this.state);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.state);
    }

    public abstract boolean isActive();

    @Override
    public long getTimeSinceLastActive() {
        if (this.isNew()) {
            return System.currentTimeMillis() - this.timeCreated;
        }
        return this.isActive() ? 0L : System.currentTimeMillis() - this.timeLastActive;
    }

    protected void updateLastActiveTime() {
        this.timeLastActive = System.currentTimeMillis();
    }

    public void delegateConnectionEstablished() throws Exception {
        this.state = State.OPEN;
        this.handler.afterConnectionEstablished(this);
    }

    public void delegateMessages(String[] messages) throws SockJsMessageDeliveryException {
        ArrayList<String> undelivered = new ArrayList<String>(Arrays.asList(messages));
        for (String message : messages) {
            try {
                if (this.isClosed()) {
                    throw new SockJsMessageDeliveryException(this.id, undelivered, null);
                }
                this.handler.handleMessage(this, new TextMessage(message));
                undelivered.remove(0);
            }
            catch (Throwable ex) {
                throw new SockJsMessageDeliveryException(this.id, undelivered, ex);
            }
        }
    }

    public final void delegateConnectionClosed(CloseStatus status) throws Exception {
        if (!this.isClosed()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " was closed, " + status));
            }
            try {
                this.updateLastActiveTime();
                this.cancelHeartbeat();
            }
            finally {
                this.state = State.CLOSED;
                this.handler.afterConnectionClosed(this, status);
            }
        }
    }

    public void delegateError(Throwable ex) throws Exception {
        this.handler.handleTransportError(this, ex);
    }

    @Override
    public final synchronized void sendMessage(WebSocketMessage<?> message) throws IOException {
        Assert.isTrue((!this.isClosed() ? 1 : 0) != 0, (String)"Cannot send a message when session is closed");
        Assert.isInstanceOf(TextMessage.class, message, (String)("Expected text message: " + message));
        this.sendMessageInternal((String)((TextMessage)message).getPayload());
    }

    protected abstract void sendMessageInternal(String var1) throws IOException;

    @Override
    public final void close() throws IOException {
        this.close(new CloseStatus(3000, "Go away!"));
    }

    @Override
    public final void close(CloseStatus status) throws IOException {
        if (this.isOpen()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing " + this + ", " + status));
            }
            try {
                if (this.isActive()) {
                    try {
                        this.writeFrameInternal(SockJsFrame.closeFrame(status.getCode(), status.getReason()));
                    }
                    catch (Throwable ex) {
                        this.logger.warn((Object)("Failed to send SockJS close frame: " + ex.getMessage()));
                    }
                }
                this.updateLastActiveTime();
                this.cancelHeartbeat();
                this.disconnect(status);
            }
            finally {
                this.state = State.CLOSED;
                try {
                    this.handler.afterConnectionClosed(this, status);
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Unhandled error for " + this), ex);
                }
            }
        }
    }

    protected abstract void disconnect(CloseStatus var1) throws IOException;

    public void tryCloseWithSockJsTransportError(Throwable ex, CloseStatus closeStatus) {
        this.logger.error((Object)("Closing due to transport error for " + this));
        try {
            this.delegateError(ex);
        }
        catch (Throwable delegateEx) {
            // empty catch block
        }
        try {
            this.close(closeStatus);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void writeFrame(SockJsFrame frame) throws SockJsTransportFailureException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Preparing to write " + frame));
        }
        try {
            this.writeFrameInternal(frame);
        }
        catch (Throwable ex) {
            if (ex instanceof EOFException || ex instanceof SocketException) {
                this.logger.warn((Object)"Client went away. Terminating connection");
            } else {
                this.logger.warn((Object)("Terminating connection after failure to send message: " + ex.getMessage()));
            }
            try {
                this.disconnect(CloseStatus.SERVER_ERROR);
                this.close(CloseStatus.SERVER_ERROR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new SockJsTransportFailureException("Failed to write " + frame, this.getId(), ex);
        }
    }

    protected abstract void writeFrameInternal(SockJsFrame var1) throws IOException;

    public synchronized void sendHeartbeat() throws SockJsTransportFailureException {
        if (this.isActive()) {
            this.writeFrame(SockJsFrame.heartbeatFrame());
            this.scheduleHeartbeat();
        }
    }

    protected void scheduleHeartbeat() {
        Assert.state((this.config.getTaskScheduler() != null ? 1 : 0) != 0, (String)"No TaskScheduler configured for heartbeat");
        this.cancelHeartbeat();
        if (!this.isActive()) {
            return;
        }
        Date time = new Date(System.currentTimeMillis() + this.config.getHeartbeatTime());
        this.heartbeatTask = this.config.getTaskScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSockJsSession.this.sendHeartbeat();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, time);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Scheduled heartbeat after " + this.config.getHeartbeatTime() / 1000L + " seconds"));
        }
    }

    protected void cancelHeartbeat() {
        if (this.heartbeatTask != null && !this.heartbeatTask.isDone()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Cancelling heartbeat");
            }
            this.heartbeatTask.cancel(false);
        }
        this.heartbeatTask = null;
    }

    public String toString() {
        return "SockJS session id=" + this.id;
    }

    private static enum State {
        NEW,
        OPEN,
        CLOSED;

    }
}

