/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security;

import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.security.WsSecurityFaultException;
import org.springframework.ws.soap.security.WsSecuritySecurementException;
import org.springframework.ws.soap.security.WsSecurityValidationException;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;
import org.springframework.ws.soap.soap11.Soap11Body;

public abstract class AbstractWsSecurityInterceptor
implements SoapEndpointInterceptor,
ClientInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final QName WS_SECURITY_NAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private boolean secureResponse = true;
    private boolean validateRequest = true;
    private boolean secureRequest = true;
    private boolean validateResponse = true;

    public void setValidateRequest(boolean validateRequest) {
        this.validateRequest = validateRequest;
    }

    public void setSecureResponse(boolean secureResponse) {
        this.secureResponse = secureResponse;
    }

    public void setSecureRequest(boolean secureRequest) {
        this.secureRequest = secureRequest;
    }

    public void setValidateResponse(boolean validateResponse) {
        this.validateResponse = validateResponse;
    }

    public final boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.validateRequest) {
            Assert.isInstanceOf((Class)SoapMessage.class, (Object)messageContext.getRequest());
            try {
                this.validateMessage((SoapMessage)messageContext.getRequest(), messageContext);
                return true;
            }
            catch (WsSecurityValidationException ex) {
                return this.handleValidationException(ex, messageContext);
            }
            catch (WsSecurityFaultException ex) {
                return this.handleFaultException(ex, messageContext);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        boolean result = true;
        try {
            if (this.secureResponse) {
                Assert.isTrue((boolean)messageContext.hasResponse(), (String)"MessageContext contains no response");
                Assert.isInstanceOf((Class)SoapMessage.class, (Object)messageContext.getResponse());
                try {
                    this.secureMessage((SoapMessage)messageContext.getResponse(), messageContext);
                }
                catch (WsSecuritySecurementException ex) {
                    result = this.handleSecurementException(ex, messageContext);
                }
                catch (WsSecurityFaultException ex) {
                    result = this.handleFaultException(ex, messageContext);
                }
            }
        }
        finally {
            if (!result) {
                messageContext.clearResponse();
            }
            this.cleanUp();
        }
        return result;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        this.cleanUp();
        return true;
    }

    public boolean understands(SoapHeaderElement headerElement) {
        return WS_SECURITY_NAME.equals(headerElement.getName());
    }

    public final boolean handleRequest(MessageContext messageContext) throws WebServiceClientException {
        if (this.secureRequest) {
            Assert.isInstanceOf((Class)SoapMessage.class, (Object)messageContext.getRequest());
            try {
                this.secureMessage((SoapMessage)messageContext.getRequest(), messageContext);
                return true;
            }
            catch (WsSecuritySecurementException ex) {
                return this.handleSecurementException(ex, messageContext);
            }
            catch (WsSecurityFaultException ex) {
                return this.handleFaultException(ex, messageContext);
            }
        }
        return true;
    }

    public final boolean handleResponse(MessageContext messageContext) throws WebServiceClientException {
        if (this.validateResponse) {
            Assert.isTrue((boolean)messageContext.hasResponse(), (String)"MessageContext contains no response");
            Assert.isInstanceOf((Class)SoapMessage.class, (Object)messageContext.getResponse());
            try {
                this.validateMessage((SoapMessage)messageContext.getResponse(), messageContext);
                return true;
            }
            catch (WsSecurityValidationException ex) {
                return this.handleValidationException(ex, messageContext);
            }
            catch (WsSecurityFaultException ex) {
                return this.handleFaultException(ex, messageContext);
            }
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) throws WebServiceClientException {
        return true;
    }

    protected boolean handleSecurementException(WsSecuritySecurementException ex, MessageContext messageContext) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)("Could not secure response: " + ex.getMessage()), (Throwable)((Object)ex));
        }
        return false;
    }

    protected boolean handleValidationException(WsSecurityValidationException ex, MessageContext messageContext) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not validate request: " + ex.getMessage()));
        }
        SoapBody response = ((SoapMessage)messageContext.getResponse()).getSoapBody();
        response.addClientOrSenderFault(ex.getMessage(), Locale.ENGLISH);
        return false;
    }

    protected boolean handleFaultException(WsSecurityFaultException ex, MessageContext messageContext) {
        SoapBody response;
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not handle request: " + ex.getMessage()));
        }
        Object fault = (response = ((SoapMessage)messageContext.getResponse()).getSoapBody()) instanceof Soap11Body ? ((Soap11Body)response).addFault(ex.getFaultCode(), ex.getFaultString(), Locale.ENGLISH) : response.addClientOrSenderFault(ex.getFaultString(), Locale.ENGLISH);
        fault.setFaultActorOrRole(ex.getFaultActor());
        return false;
    }

    protected abstract void validateMessage(SoapMessage var1, MessageContext var2) throws WsSecurityValidationException;

    protected abstract void secureMessage(SoapMessage var1, MessageContext var2) throws WsSecuritySecurementException;

    protected abstract void cleanUp();
}

